/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityBreakingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import squeek.veganoption.blocks.BlockEnderRift;
import squeek.veganoption.content.modules.Egg;
import squeek.veganoption.content.modules.FrozenBubble;
import squeek.veganoption.helpers.NetworkHelper;
import squeek.veganoption.helpers.RandomHelper;

public class MessageFX
implements IMessage,
IMessageHandler<MessageFX, IMessage> {
    double x;
    double y;
    double z;
    FX fx;

    public MessageFX() {
    }

    public MessageFX(double x, double y, double z, FX fx) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.fx = fx;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeByte(this.fx.ordinal());
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.fx = FX.values()[buf.readByte()];
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(MessageFX message, MessageContext ctx) {
        switch (message.fx) {
            case BUBBLE_POP: {
                this.doEntityBreakFX(message, ctx, FrozenBubble.frozenBubble);
                break;
            }
            case BLOCK_TELEPORT: {
                BlockEnderRift.spawnBlockTeleportFX(NetworkHelper.getSidedWorld(ctx), message.x, message.y, message.z, RandomHelper.random);
                break;
            }
            case PLASTIC_EGG_BREAK: {
                this.doEntityBreakFX(message, ctx, Egg.plasticEgg);
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void doEntityBreakFX(MessageFX message, MessageContext ctx, Item breakFXItem) {
        this.doEntityBreakFX(message, ctx, breakFXItem, 8);
    }

    @SideOnly(value=Side.CLIENT)
    public void doEntityBreakFX(MessageFX message, MessageContext ctx, Item breakFXItem, int iterations) {
        this.doEntityBreakFX(NetworkHelper.getSidedWorld(ctx), message.x, message.y, message.z, breakFXItem, iterations);
    }

    @SideOnly(value=Side.CLIENT)
    public void doEntityBreakFX(World world, double x, double y, double z, Item breakFXItem, int iterations) {
        Minecraft mc = Minecraft.func_71410_x();
        for (int i = 0; i < iterations; ++i) {
            mc.field_71452_i.func_78873_a((EntityFX)new EntityBreakingFX(world, x, y, z, breakFXItem));
        }
    }

    public static enum FX {
        BUBBLE_POP,
        BLOCK_TELEPORT,
        PLASTIC_EGG_BREAK;

    }
}

