/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.BlockHay;
import net.minecraft.item.Item;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import squeek.veganoption.helpers.BlockHelper;
import squeek.veganoption.helpers.ColorHelper;
import squeek.veganoption.helpers.RandomHelper;

public class BlockRettable
extends BlockHay {
    public int numRettingStages = 3;
    public int baseColor = 6802956;
    public int rettedColor = 12563838;
    public Item rettedItem;
    public int minRettedItemDrops;
    public int maxRettedItemDrops;

    public BlockRettable(Item rettedItem, int minRettedItemDrops, int maxRettedItemDrops) {
        this.func_149675_a(true);
        this.rettedItem = rettedItem;
        this.minRettedItemDrops = minRettedItemDrops;
        this.maxRettedItemDrops = maxRettedItemDrops;
    }

    public BlockRettable(Item rettedItem, int minRettedItemDrops, int maxRettedItemDrops, int baseColor, int rettedColor) {
        this(rettedItem, minRettedItemDrops, maxRettedItemDrops);
        this.baseColor = baseColor;
        this.rettedColor = rettedColor;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        if (this.isRetted(world, x, y, z)) {
            return this.rettedColor;
        }
        return ColorHelper.blendBetweenColors(this.getRettingPercent(world, x, y, z), this.baseColor, this.rettedColor, 0.0, 1.0);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        return this.baseColor;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int p_149741_1_) {
        return this.baseColor;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        super.func_149674_a(world, x, y, z, random);
        if (this.canRet(world, x, y, z) && !this.isRetted((IBlockAccess)world, x, y, z)) {
            this.deltaRettingStage(world, x, y, z, 1);
        }
    }

    public void finishRetting(World world, int x, int y, int z) {
    }

    public boolean canRet(World world, int x, int y, int z) {
        return BlockHelper.isAdjacentToOrCoveredInWater(BlockHelper.blockPos(world, x, y, z));
    }

    public boolean isRetted(int meta) {
        return this.getRettingStageFromMeta(meta) >= this.numRettingStages;
    }

    public boolean isRetted(IBlockAccess world, int x, int y, int z) {
        return this.isRetted(world.func_72805_g(x, y, z));
    }

    protected boolean func_149700_E() {
        return false;
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        if (this.isRetted(meta)) {
            return this.rettedItem;
        }
        return super.func_149650_a(meta, random, fortune);
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        if (this.isRetted(meta)) {
            return RandomHelper.getRandomIntFromRange(random, this.minRettedItemDrops, this.maxRettedItemDrops);
        }
        return super.quantityDropped(meta, fortune, random);
    }

    public boolean isToolEffective(String type, int metadata) {
        if (this.isRetted(metadata)) {
            return false;
        }
        return super.isToolEffective(type, metadata);
    }

    public void setHarvestLevel(String toolClass, int level, int metadata) {
        if (this.isRetted(metadata)) {
            return;
        }
        super.setHarvestLevel(toolClass, level, metadata);
    }

    public int func_149692_a(int p_149692_1_) {
        return 0;
    }

    public void deltaRettingStage(World world, int x, int y, int z, int deltaRetting) {
        this.setRettingStage(world, x, y, z, this.getRettingStage((IBlockAccess)world, x, y, z) + deltaRetting);
    }

    public void setRettingStage(World world, int x, int y, int z, int rettingStage) {
        rettingStage = Math.max(0, Math.min(this.numRettingStages, rettingStage));
        int metadata = this.getMetaFromRettingStage((IBlockAccess)world, x, y, z, rettingStage);
        world.func_72921_c(x, y, z, metadata, 3);
        if (this.isRetted(metadata)) {
            this.finishRetting(world, x, y, z);
        }
    }

    public float getRettingPercent(IBlockAccess world, int x, int y, int z) {
        return this.getRettingPercentFromMeta(world.func_72805_g(x, y, z));
    }

    public float getRettingPercentFromMeta(int meta) {
        return (float)this.getRettingStageFromMeta(meta) / (float)this.numRettingStages;
    }

    public int getRettingStage(IBlockAccess world, int x, int y, int z) {
        return this.getRettingStageFromMeta(world.func_72805_g(x, y, z));
    }

    public int getRettingStageFromMeta(int meta) {
        return meta & 3;
    }

    public int getMetaFromRettingStage(IBlockAccess world, int x, int y, int z, int rettingStage) {
        return (world.func_72805_g(x, y, z) & 0xC) + rettingStage;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        return MathHelper.func_76141_d((float)(this.getRettingPercent((IBlockAccess)world, x, y, z) * 15.0f));
    }
}

