/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.blocks.renderers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Calendar;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import squeek.veganoption.ModInfo;
import squeek.veganoption.blocks.renderers.ModelComposterLegs;
import squeek.veganoption.blocks.tiles.TileEntityComposter;

@SideOnly(value=Side.CLIENT)
public class RenderComposter
extends TileEntitySpecialRenderer
implements IItemRenderer {
    private static final ResourceLocation TEXTURE_CHRISTMAS = new ResourceLocation("textures/entity/chest/christmas.png");
    private static final ResourceLocation TEXTURE_NORMAL = new ResourceLocation("textures/entity/chest/normal.png");
    private static final ResourceLocation TEXTURE_LEGS = new ResourceLocation(ModInfo.MODID_LOWER, "textures/entity/composter_legs.png");
    private ModelChest modelChest = new ModelChest();
    private ModelComposterLegs modelLegs = new ModelComposterLegs();
    private boolean isChristmas;
    private TileEntityComposter dummyItemRenderTile = new TileEntityComposter();

    public RenderComposter() {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            this.isChristmas = true;
        }
    }

    public void renderTileEntityAt(TileEntityComposter tile, double x, double y, double z, float partialTickTime) {
        long ticksSinceLastAeration;
        int meta = !tile.func_145830_o() ? ForgeDirection.WEST.ordinal() : tile.func_145832_p();
        int rotation = 0;
        if (meta == ForgeDirection.NORTH.ordinal()) {
            rotation = 0;
        } else if (meta == ForgeDirection.SOUTH.ordinal()) {
            rotation = 180;
        } else if (meta == ForgeDirection.EAST.ordinal()) {
            rotation = 90;
        } else if (meta == ForgeDirection.WEST.ordinal()) {
            rotation = -90;
        }
        Axis axis = Math.abs(rotation) == 90 ? Axis.X : Axis.Y;
        this.func_147499_a(TEXTURE_LEGS);
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        this.modelLegs.renderAll();
        GL11.glPopMatrix();
        ModelChest modelchest = this.modelChest;
        if (this.isChristmas) {
            this.func_147499_a(TEXTURE_CHRISTMAS);
        } else {
            this.func_147499_a(TEXTURE_NORMAL);
        }
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)x + (axis == Axis.X ? 0.1f : 0.0f)), (float)((float)y + 1.0f), (float)((float)z + (axis == Axis.X ? 1.0f : 0.9f)));
        GL11.glScalef((float)(axis == Axis.X ? 0.8f : 1.0f), (float)-0.8f, (float)(axis == Axis.X ? -1.0f : -0.8f));
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        if (tile.func_145830_o() && (ticksSinceLastAeration = tile.func_145831_w().func_72820_D() - tile.lastAeration) <= 100L) {
            int num_turns = 3;
            double percent = (double)ticksSinceLastAeration / 100.0;
            GL11.glRotatef((float)((float)(-(percent * 360.0 * 3.0))), (float)(axis == Axis.X ? 0.0f : 1.0f), (float)0.0f, (float)(axis == Axis.X ? 1.0f : 0.0f));
        }
        GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        float f1 = tile.prevLidAngle + (tile.lidAngle - tile.prevLidAngle) * partialTickTime;
        f1 = 1.0f - f1;
        f1 = 1.0f - f1 * f1 * f1;
        modelchest.field_78234_a.field_78795_f = -(f1 * (float)Math.PI / 2.0f);
        modelchest.func_78231_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public void func_147500_a(TileEntity p_147500_1_, double p_147500_2_, double p_147500_4_, double p_147500_6_, float p_147500_8_) {
        this.renderTileEntityAt((TileEntityComposter)p_147500_1_, p_147500_2_, p_147500_4_, p_147500_6_, p_147500_8_);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                this.renderTileEntityAt(this.dummyItemRenderTile, -0.5, 0.0, -0.5, 0.0f);
                return;
            }
            case EQUIPPED: {
                this.renderTileEntityAt(this.dummyItemRenderTile, 0.0, 0.0, 0.0, 0.0f);
                return;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.renderTileEntityAt(this.dummyItemRenderTile, 0.0, 0.0, 0.0, 0.0f);
                return;
            }
            case INVENTORY: {
                this.renderTileEntityAt(this.dummyItemRenderTile, 0.5, 0.3f, 0.5, 0.0f);
                return;
            }
        }
    }

    protected static enum Axis {
        X,
        Y;

    }
}

