/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.helpers;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Method;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import squeek.veganoption.helpers.RandomHelper;

public class InventoryHelper {
    public static final Method hopperInsertIntoInventory = ReflectionHelper.findMethod(TileEntityHopper.class, null, (String[])new String[]{"func_145899_c", "c"}, (Class[])new Class[]{IInventory.class, ItemStack.class, Integer.TYPE, Integer.TYPE});

    public static IInventory getInventoryAtLocation(World world, int x, int y, int z) {
        return TileEntityHopper.func_145893_b((World)world, (double)x, (double)y, (double)z);
    }

    public static ItemStack insertStackIntoInventory(ItemStack itemStack, IInventory inventory) {
        return TileEntityHopper.func_145889_a((IInventory)inventory, (ItemStack)itemStack, (int)ForgeDirection.DOWN.ordinal());
    }

    public static void dropAllInventoryItemsInWorld(World world, int x, int y, int z, IInventory inventory) {
        if (inventory == null) {
            return;
        }
        for (int slotNum = 0; slotNum < inventory.func_70302_i_(); ++slotNum) {
            ItemStack itemstack = inventory.func_70301_a(slotNum);
            if (itemstack == null) continue;
            float xOffset = RandomHelper.random.nextFloat() * 0.8f + 0.1f;
            float yOffset = RandomHelper.random.nextFloat() * 0.8f + 0.1f;
            float zOffset = RandomHelper.random.nextFloat() * 0.8f + 0.1f;
            while (itemstack.field_77994_a > 0) {
                int stackSizeToDrop = RandomHelper.random.nextInt(21) + 10;
                if (stackSizeToDrop > itemstack.field_77994_a) {
                    stackSizeToDrop = itemstack.field_77994_a;
                }
                itemstack.field_77994_a -= stackSizeToDrop;
                EntityItem entityitem = new EntityItem(world, (double)((float)x + xOffset), (double)((float)y + yOffset), (double)((float)z + zOffset), new ItemStack(itemstack.func_77973_b(), stackSizeToDrop, itemstack.func_77960_j()));
                float velocityScale = 0.05f;
                entityitem.field_70159_w = (float)RandomHelper.random.nextGaussian() * velocityScale;
                entityitem.field_70181_x = (float)RandomHelper.random.nextGaussian() * velocityScale + 0.2f;
                entityitem.field_70179_y = (float)RandomHelper.random.nextGaussian() * velocityScale;
                if (itemstack.func_77942_o()) {
                    entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                }
                world.func_72838_d((Entity)entityitem);
            }
        }
    }

    public static float getPercentInventoryFilled(IInventory inventory) {
        if (inventory == null || inventory.func_70302_i_() == 0) {
            return 0.0f;
        }
        float filledPercent = 0.0f;
        for (int slotNum = 0; slotNum < inventory.func_70302_i_(); ++slotNum) {
            ItemStack itemstack = inventory.func_70301_a(slotNum);
            if (itemstack == null) continue;
            filledPercent += (float)itemstack.field_77994_a / (float)Math.min(inventory.func_70297_j_(), itemstack.func_77976_d());
        }
        return filledPercent /= (float)inventory.func_70302_i_();
    }
}

