/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.integration.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraftforge.oredict.OreDictionary;
import squeek.veganoption.content.registry.RelationshipRegistry;
import squeek.veganoption.helpers.LangHelper;
import squeek.veganoption.helpers.MiscHelper;

public class TextHandler
implements IUsageHandler,
ICraftingHandler {
    public static final FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
    public static final int WIDTH = 166;
    public static final int HEIGHT = 130;
    public static final int Y_START = 22;
    public static final int PADDING = 4;
    public static final int MAX_LINES_PER_PAGE = 108 / TextHandler.fontRenderer.field_78288_b - 1;
    public String text = null;
    public ItemStack itemStack = null;
    public boolean isUsage;
    public List<String> splitText = new ArrayList<String>();
    public int firstPageMaxLines = MAX_LINES_PER_PAGE;
    public List<ItemStack> children;
    public List<ItemStack> parents;
    public List<ItemStack> referenced = new ArrayList<ItemStack>();

    public TextHandler() {
    }

    public TextHandler(ItemStack itemStack, boolean isUsage) {
        this.itemStack = itemStack.func_77946_l();
        this.itemStack.field_77994_a = 1;
        this.isUsage = isUsage;
        this.children = isUsage ? RelationshipRegistry.getChildren(itemStack) : null;
        this.parents = !isUsage ? RelationshipRegistry.getParents(itemStack) : null;
        String string = this.text = isUsage ? this.getUsageOfItemStack(this.itemStack) : this.getCraftingOfItemStack(this.itemStack);
        if (this.parents != null) {
            for (ItemStack parent : this.parents) {
                String parentString = this.getUsageOfItemStack(parent);
                if (parentString.isEmpty()) continue;
                this.text = this.text + (!this.text.isEmpty() ? "\n\n" : "") + parentString;
            }
        } else if (this.children != null) {
            for (ItemStack child : this.children) {
                String childString = this.getCraftingOfItemStack(child);
                if (childString.isEmpty()) continue;
                this.text = this.text + (!this.text.isEmpty() ? "\n\n" : "") + childString;
            }
        }
        if (this.parents != null || this.children != null) {
            this.firstPageMaxLines -= 3;
        }
        this.text = this.processText(this.text);
        if (this.referenced.size() > 0) {
            this.firstPageMaxLines -= 3;
        }
        this.splitText = this.splitText(this.text);
        for (int page = 0; page < this.numRecipes(); ++page) {
            int startingLineIndex = this.getStartingLine(page);
            while (!this.splitText.isEmpty() && EnumChatFormatting.func_110646_a((String)this.splitText.get(startingLineIndex)).isEmpty()) {
                this.splitText.remove(startingLineIndex);
            }
        }
    }

    public String getStringOfItemStack(String string, ItemStack itemStack) {
        if (LangHelper.existsRaw(string)) {
            return LangHelper.translateRaw(string, EnumChatFormatting.BLACK + itemStack.func_82833_r() + EnumChatFormatting.RESET);
        }
        return "";
    }

    public String getUsageOfItemStack(ItemStack itemStack) {
        return this.getStringOfItemStack(itemStack.func_77977_a() + ".nei.usage", itemStack);
    }

    public String getCraftingOfItemStack(ItemStack itemStack) {
        return this.getStringOfItemStack(itemStack.func_77977_a() + ".nei.crafting", itemStack);
    }

    public List<String> splitText(String text) {
        if (text == null) {
            return null;
        }
        return new ArrayList<String>(fontRenderer.func_78271_c(text, 158));
    }

    public String processText(String text) {
        if (text == null) {
            return null;
        }
        text = text.replaceAll("\\\\n", String.valueOf('\n'));
        Matcher localizationMatcher = Pattern.compile("\\{([^\\}]+)\\}").matcher(text);
        StringBuffer localizedBuffer = new StringBuffer(text.length());
        while (localizationMatcher.find()) {
            localizationMatcher.appendReplacement(localizedBuffer, this.getStringOfItemStack(localizationMatcher.group(1), this.itemStack));
        }
        localizationMatcher.appendTail(localizedBuffer);
        text = localizedBuffer.toString();
        Matcher referenceMatcher = Pattern.compile("\\[\\[([^\\]:]+:[^\\]:]+):?(\\d+)?\\]\\]").matcher(text);
        StringBuffer referencedBuffer = new StringBuffer(text.length());
        while (referenceMatcher.find()) {
            ItemStack itemStack;
            String objectName = referenceMatcher.group(1);
            int meta = 0;
            if (referenceMatcher.groupCount() > 1) {
                try {
                    meta = new Integer(referenceMatcher.group(2));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if ((itemStack = MiscHelper.getItemStackByObjectName(objectName)) == null || itemStack.func_77973_b() == null) continue;
            itemStack.func_77964_b(meta);
            if (!this.isReferenceRedundant(itemStack)) {
                this.referenced.add(itemStack);
            }
            referenceMatcher.appendReplacement(referencedBuffer, EnumChatFormatting.DARK_BLUE + itemStack.func_82833_r() + EnumChatFormatting.RESET);
        }
        referenceMatcher.appendTail(referencedBuffer);
        text = referencedBuffer.toString();
        return text;
    }

    public boolean isReferenceRedundant(ItemStack itemStack) {
        return OreDictionary.itemMatches((ItemStack)this.itemStack, (ItemStack)itemStack, (boolean)false) || MiscHelper.isItemStackInList(this.referenced, itemStack) || MiscHelper.isItemStackInList(this.children, itemStack) || MiscHelper.isItemStackInList(this.parents, itemStack);
    }

    public boolean hasUsageText(ItemStack itemStack) {
        return LangHelper.existsRaw(itemStack.func_77977_a() + ".nei.usage") || RelationshipRegistry.getChildren(itemStack) != null;
    }

    public boolean hasRecipeText(ItemStack itemStack) {
        return LangHelper.existsRaw(itemStack.func_77977_a() + ".nei.crafting") || RelationshipRegistry.getParents(itemStack) != null;
    }

    public IUsageHandler getUsageHandler(String inputId, Object ... ingredients) {
        if (inputId.equals("item")) {
            for (Object ingredient : ingredients) {
                if (!(ingredient instanceof ItemStack) || !this.hasUsageText((ItemStack)ingredient)) continue;
                return new TextHandler((ItemStack)ingredient, true);
            }
        }
        return this;
    }

    public ICraftingHandler getRecipeHandler(String outputId, Object ... results) {
        if (outputId.equals("item")) {
            for (Object result : results) {
                if (!(result instanceof ItemStack) || !this.hasRecipeText((ItemStack)result)) continue;
                return new TextHandler((ItemStack)result, false);
            }
        }
        return this;
    }

    public String getRecipeName() {
        return this.isUsage ? LangHelper.translate("nei.usage") : LangHelper.translate("nei.crafting");
    }

    public int numRecipes() {
        if (this.text == null && this.children == null && this.parents == null) {
            return 0;
        }
        return this.splitText.size() > this.firstPageMaxLines ? 1 + MathHelper.func_76123_f((float)((float)(this.splitText.size() - this.firstPageMaxLines) / (float)MAX_LINES_PER_PAGE)) : 1;
    }

    public void drawBackground(int recipe) {
    }

    public int getStartingLine(int recipe) {
        if (recipe == 0) {
            return 0;
        }
        return this.firstPageMaxLines + (recipe - 1) * MAX_LINES_PER_PAGE;
    }

    public void drawForeground(int recipe) {
        int y = 22;
        if (this.parents != null && recipe == 0) {
            String byproductOfString = LangHelper.translate("nei.byproduct.of");
            GuiDraw.drawString((String)byproductOfString, (int)(83 - GuiDraw.getStringWidth((String)byproductOfString) / 2), (int)y, (int)0x404040, (boolean)false);
            y += TextHandler.fontRenderer.field_78288_b + 18 + 4;
        }
        if (this.children != null && recipe == 0) {
            String byproductsString = LangHelper.translate("nei.byproducts");
            GuiDraw.drawString((String)byproductsString, (int)(83 - GuiDraw.getStringWidth((String)byproductsString) / 2), (int)y, (int)0x404040, (boolean)false);
            y += TextHandler.fontRenderer.field_78288_b + 18 + 4;
        }
        if (this.text != null) {
            int maxLines = recipe == 0 ? this.firstPageMaxLines : MAX_LINES_PER_PAGE;
            int startLine = this.getStartingLine(recipe);
            int endLine = Math.min(startLine + maxLines, this.splitText.size());
            for (int i = startLine; i < endLine; ++i) {
                String line = this.splitText.get(i);
                GuiDraw.drawString((String)line, (int)(83 - GuiDraw.getStringWidth((String)line) / 2), (int)y, (int)0x404040, (boolean)false);
                y += TextHandler.fontRenderer.field_78288_b;
            }
        }
        if (this.referenced.size() > 0 && recipe == 0) {
            y = 112 - TextHandler.fontRenderer.field_78288_b;
            String referencesString = LangHelper.translate("nei.references");
            GuiDraw.drawString((String)referencesString, (int)(83 - GuiDraw.getStringWidth((String)referencesString) / 2), (int)y, (int)0x404040, (boolean)false);
        }
    }

    public List<PositionedStack> getIngredientStacks(int recipe) {
        ArrayList<PositionedStack> positionedParents = new ArrayList<PositionedStack>();
        if (this.parents != null && recipe == 0) {
            int startX = 83 - this.parents.size() * 18 / 2;
            int startY = 22 + TextHandler.fontRenderer.field_78288_b;
            for (int i = 0; i < this.parents.size(); ++i) {
                positionedParents.add(new PositionedStack((Object)this.parents.get(i), startX + i * 18, startY, false));
            }
        }
        return positionedParents;
    }

    public List<PositionedStack> getOtherStacks(int recipe) {
        int i;
        ArrayList<PositionedStack> positionedChildren = new ArrayList<PositionedStack>();
        if (this.children != null && recipe == 0) {
            int startX = 83 - this.children.size() * 18 / 2;
            int startY = 22 + TextHandler.fontRenderer.field_78288_b + (this.parents != null ? TextHandler.fontRenderer.field_78288_b + 18 + 4 : 0);
            for (i = 0; i < this.children.size(); ++i) {
                positionedChildren.add(new PositionedStack((Object)this.children.get(i), startX + i * 18, startY, false));
            }
        }
        if (this.referenced.size() > 0 && recipe == 0) {
            int referencedX = 83 - this.referenced.size() * 18 / 2;
            int referencedY = 112;
            for (i = 0; i < this.referenced.size(); ++i) {
                positionedChildren.add(new PositionedStack((Object)this.referenced.get(i), referencedX + i * 18, referencedY, false));
            }
        }
        return positionedChildren;
    }

    public PositionedStack getResultStack(int recipe) {
        return new PositionedStack((Object)this.itemStack, 74, 0, false);
    }

    public void onUpdate() {
    }

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return false;
    }

    public IRecipeOverlayRenderer getOverlayRenderer(GuiContainer gui, int recipe) {
        return null;
    }

    public IOverlayHandler getOverlayHandler(GuiContainer gui, int recipe) {
        return null;
    }

    public int recipiesPerPage() {
        return 1;
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        return currenttip;
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack stack, List<String> currenttip, int recipe) {
        return currenttip;
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        return false;
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        return false;
    }
}

