/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.integration.tic;

import cpw.mods.fml.common.event.FMLInterModComms;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.oredict.OreDictionary;
import squeek.veganoption.content.modules.Bioplastic;
import squeek.veganoption.content.registry.CompostRegistry;
import squeek.veganoption.helpers.LangHelper;
import squeek.veganoption.integration.IntegrationHandler;
import squeek.veganoption.integration.IntegratorBase;

public class TConstruct
extends IntegratorBase {
    public static final int MATID_PLASTIC = 1000;
    public static final String MATNAME_PLASTIC = "Plastic";
    public static final String KEY_PLASTICROD_MATERIALSET = "BioplasticRodSet";
    public static final String ITEMNAME_TOOLROD = "toolRod";
    public static final String ITEMNAME_JERKY = "jerky";
    public static final String ITEMNAME_GOLDENHEAD = "goldHead";
    public static final String ITEMNAME_DIAMONDAPPLE = "diamondApple";
    public static final String ITEMNAME_STRANGEFOOD = "strangeFood";
    public static List<ItemStack> plasticRodItems = null;
    public static final String patternBuilderClassName = "tconstruct.library.crafting.PatternBuilder";
    public static Object PatternBuilder = null;
    public static Method registerMaterialSet = null;

    @Override
    public void oredict() {
        super.oredict();
        ItemStack plasticToolRod = new ItemStack(this.getItem(ITEMNAME_TOOLROD), 1, 1000);
        OreDictionary.registerOre((String)"stickPlastic", (ItemStack)plasticToolRod);
    }

    @Override
    public void init() {
        super.init();
        this.registerPlasticToolMaterial();
        CompostRegistry.blacklist(new CompostRegistry.FoodSpecifier(){
            private final Set<String> itemNameBlacklist;
            {
                this.itemNameBlacklist = new HashSet<String>(Arrays.asList(TConstruct.this.fullItemName(TConstruct.ITEMNAME_JERKY), TConstruct.this.fullItemName(TConstruct.ITEMNAME_GOLDENHEAD), TConstruct.this.fullItemName(TConstruct.ITEMNAME_DIAMONDAPPLE), TConstruct.this.fullItemName(TConstruct.ITEMNAME_STRANGEFOOD)));
            }

            @Override
            public boolean matches(ItemStack itemStack) {
                String itemName = Item.field_150901_e.func_148750_c((Object)itemStack.func_77973_b());
                return this.itemNameBlacklist.contains(itemName);
            }
        });
    }

    public void registerPlasticToolMaterial() {
        NBTTagCompound tag = new NBTTagCompound();
        if (!IntegrationHandler.integrationExists("MineFactoryReloaded")) {
            tag.func_74768_a("Id", 1000);
            tag.func_74778_a("Name", MATNAME_PLASTIC);
            tag.func_74778_a("localizationString", LangHelper.prependModId("tic.material.plastic"));
            tag.func_74768_a("Durability", 1500);
            tag.func_74768_a("MiningSpeed", 600);
            tag.func_74768_a("HarvestLevel", 1);
            tag.func_74768_a("Attack", -1);
            tag.func_74776_a("HandleModifier", 0.1f);
            tag.func_74776_a("Bow_ProjectileSpeed", 4.2f);
            tag.func_74768_a("Bow_DrawSpeed", 20);
            tag.func_74776_a("Projectile_Mass", 0.25f);
            tag.func_74776_a("Projectile_Fragility", 0.5f);
            tag.func_74778_a("Style", EnumChatFormatting.GRAY.toString());
            tag.func_74768_a("Color", -5395027);
            FMLInterModComms.sendMessage((String)this.modID, (String)"addMaterial", (NBTTagCompound)tag);
            tag = new NBTTagCompound();
            tag.func_74768_a("MaterialId", 1000);
            tag.func_74782_a("Item", (NBTBase)new ItemStack(Bioplastic.bioplastic).func_77955_b(new NBTTagCompound()));
            tag.func_74768_a("Value", 1);
            FMLInterModComms.sendMessage((String)this.modID, (String)"addPartBuilderMaterial", (NBTTagCompound)tag);
            this.registerShardAndRod(KEY_PLASTICROD_MATERIALSET, null, new ItemStack(Bioplastic.plasticRod), 1000);
        } else {
            this.registerShardAndRod(KEY_PLASTICROD_MATERIALSET, new ItemStack(Bioplastic.bioplastic), new ItemStack(Bioplastic.plasticRod), 1000);
        }
    }

    public static ItemStack getRealHandle(ItemStack itemStack) {
        if (plasticRodItems == null) {
            plasticRodItems = OreDictionary.getOres((String)"stickPlastic");
        }
        for (ItemStack item : plasticRodItems) {
            Item toolRodItem;
            if (!OreDictionary.itemMatches((ItemStack)item, (ItemStack)itemStack, (boolean)false) || (toolRodItem = (Item)Item.field_150901_e.func_82594_a("TConstruct:toolRod")) == null) continue;
            return new ItemStack(toolRodItem, 1, 1000);
        }
        return itemStack;
    }

    public void registerShardAndRod(String key, ItemStack shard, ItemStack rod, int matID) {
        try {
            registerMaterialSet.invoke(PatternBuilder, key, shard, rod, matID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            Class<?> patternBuilderClass = Class.forName(patternBuilderClassName);
            Field instanceField = patternBuilderClass.getDeclaredField("instance");
            PatternBuilder = instanceField.get(null);
            registerMaterialSet = patternBuilderClass.getDeclaredMethod("registerMaterialSet", String.class, ItemStack.class, ItemStack.class, Integer.TYPE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

