/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.achievement.GuiAchievement;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.stats.Achievement;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipeList;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.PacketHandlerServer;
import noppes.npcs.Server;
import noppes.npcs.ServerEventsHandler;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.QuestAchievement;
import noppes.npcs.client.RenderChatMessages;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.client.gui.GuiNpcMobSpawnerAdd;
import noppes.npcs.client.gui.player.GuiBook;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.IGuiClose;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiError;
import noppes.npcs.client.gui.util.IScrollData;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.controllers.RecipeCarpentry;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.entity.EntityNPCInterface;

public class PacketHandlerClient
extends PacketHandlerServer {
    @SubscribeEvent
    public void onPacketData(FMLNetworkEvent.ClientCustomPacketEvent event) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        ByteBuf buffer = event.packet.payload();
        try {
            this.client(buffer, (EntityPlayer)player, EnumPacketClient.values()[buffer.readInt()]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void client(ByteBuf buffer, EntityPlayer player, EnumPacketClient type) throws IOException {
        if (type == EnumPacketClient.CHATBUBBLE) {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(buffer.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            EntityNPCInterface npc = (EntityNPCInterface)entity;
            if (npc.messages == null) {
                npc.messages = new RenderChatMessages();
            }
            String text = NoppesStringUtils.formatText(Server.readString(buffer), player.getDisplayName());
            npc.messages.addMessage(text);
            player.func_145747_a((IChatComponent)new ChatComponentTranslation(npc.func_70005_c_() + ": " + text, new Object[0]));
        } else if (type == EnumPacketClient.CHAT) {
            String str;
            String message = "";
            while ((str = Server.readString(buffer)) != null && !str.isEmpty()) {
                message = message + StatCollector.func_74838_a((String)str);
            }
            player.func_145747_a((IChatComponent)new ChatComponentTranslation(message, new Object[0]));
        } else if (type == EnumPacketClient.MESSAGE) {
            String description = StatCollector.func_74838_a((String)Server.readString(buffer));
            String message = Server.readString(buffer);
            QuestAchievement ach = new QuestAchievement(message, description);
            Minecraft.func_71410_x().field_71458_u.func_146256_a((Achievement)ach);
            ObfuscationReflectionHelper.setPrivateValue(GuiAchievement.class, (Object)Minecraft.func_71410_x().field_71458_u, (Object)ach.func_75989_e(), (int)4);
        } else if (type == EnumPacketClient.SYNCRECIPES_ADD) {
            NBTTagList list = Server.readNBT(buffer).func_150295_c("recipes", 10);
            if (list == null) {
                return;
            }
            for (int i = 0; i < list.func_74745_c(); ++i) {
                RecipeCarpentry recipe = new RecipeCarpentry();
                recipe.readNBT(list.func_150305_b(i));
                RecipeController.syncRecipes.put(recipe.id, recipe);
            }
        } else if (type == EnumPacketClient.SYNCRECIPES_WORKBENCH) {
            RecipeController.reloadGlobalRecipes(RecipeController.syncRecipes);
            RecipeController.syncRecipes = new HashMap();
        } else if (type == EnumPacketClient.SYNCRECIPES_CARPENTRYBENCH) {
            RecipeController.instance.anvilRecipes = RecipeController.syncRecipes;
            RecipeController.syncRecipes = new HashMap();
        } else if (type == EnumPacketClient.DIALOG) {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(buffer.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            NoppesUtil.openDialog(Server.readNBT(buffer), (EntityNPCInterface)entity, player);
        } else if (type == EnumPacketClient.QUEST_COMPLETION) {
            NoppesUtil.guiQuestCompletion(player, Server.readNBT(buffer));
        } else if (type == EnumPacketClient.EDIT_NPC) {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(buffer.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            NoppesUtil.setLastNpc((EntityNPCInterface)entity);
        } else if (type == EnumPacketClient.PLAY_MUSIC) {
            MusicController.Instance.playMusic(Server.readString(buffer), (Entity)player);
        } else if (type == EnumPacketClient.PLAY_SOUND) {
            MusicController.Instance.playSound(Server.readString(buffer), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        } else if (type == EnumPacketClient.UPDATE_NPC) {
            NBTTagCompound compound = Server.readNBT(buffer);
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(compound.func_74762_e("EntityId"));
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            ((EntityNPCInterface)entity).readSpawnData(compound);
        } else if (type == EnumPacketClient.ROLE) {
            NBTTagCompound compound = Server.readNBT(buffer);
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(compound.func_74762_e("EntityId"));
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            ((EntityNPCInterface)entity).advanced.setRole(compound.func_74762_e("Role"));
            ((EntityNPCInterface)entity).roleInterface.readFromNBT(compound);
            NoppesUtil.setLastNpc((EntityNPCInterface)entity);
        } else if (type == EnumPacketClient.GUI) {
            EnumGuiType gui = EnumGuiType.values()[buffer.readInt()];
            CustomNpcs.proxy.openGui(NoppesUtil.getLastNpc(), gui, buffer.readInt(), buffer.readInt(), buffer.readInt());
        } else if (type == EnumPacketClient.PARTICLE) {
            NoppesUtil.spawnParticle(buffer);
        } else if (type == EnumPacketClient.DELETE_NPC) {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(buffer.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            ((EntityNPCInterface)entity).delete();
        } else if (type == EnumPacketClient.SCROLL_LIST) {
            NoppesUtil.setScrollList(buffer);
        } else if (type == EnumPacketClient.SCROLL_DATA) {
            NoppesUtil.setScrollData(buffer);
        } else if (type == EnumPacketClient.SCROLL_SELECTED) {
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui == null || !(gui instanceof IScrollData)) {
                return;
            }
            String selected = Server.readString(buffer);
            ((IScrollData)gui).setSelected(selected);
        } else if (type == EnumPacketClient.GUI_REDSTONE) {
            NoppesUtil.saveRedstoneBlock(player, Server.readNBT(buffer));
        } else if (type == EnumPacketClient.GUI_WAYPOINT) {
            NoppesUtil.saveWayPointBlock(player, Server.readNBT(buffer));
        } else if (type == EnumPacketClient.CLONE) {
            NBTTagCompound compound = Server.readNBT(buffer);
            NoppesUtil.openGUI(player, new GuiNpcMobSpawnerAdd(compound));
        } else if (type == EnumPacketClient.GUI_DATA) {
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui == null) {
                return;
            }
            if (gui instanceof GuiNPCInterface && ((GuiNPCInterface)gui).hasSubGui()) {
                gui = ((GuiNPCInterface)gui).getSubGui();
            } else if (gui instanceof GuiContainerNPCInterface && ((GuiContainerNPCInterface)gui).hasSubGui()) {
                gui = ((GuiContainerNPCInterface)gui).getSubGui();
            }
            if (gui instanceof IGuiData) {
                ((IGuiData)gui).setGuiData(Server.readNBT(buffer));
            }
        } else if (type == EnumPacketClient.GUI_ERROR) {
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui == null || !(gui instanceof IGuiError)) {
                return;
            }
            int i = buffer.readInt();
            NBTTagCompound compound = Server.readNBT(buffer);
            ((IGuiError)gui).setError(i, compound);
        } else if (type == EnumPacketClient.GUI_CLOSE) {
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui == null) {
                return;
            }
            if (gui instanceof IGuiClose) {
                int i = buffer.readInt();
                NBTTagCompound compound = Server.readNBT(buffer);
                ((IGuiClose)gui).setClose(i, compound);
            }
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_147108_a(null);
            mc.func_71381_h();
        } else if (type == EnumPacketClient.VILLAGER_LIST) {
            MerchantRecipeList merchantrecipelist = MerchantRecipeList.func_151390_b((PacketBuffer)new PacketBuffer(buffer));
            ServerEventsHandler.Merchant.func_70930_a(merchantrecipelist);
        } else if (type == EnumPacketClient.OPEN_BOOK) {
            int x = buffer.readInt();
            int y = buffer.readInt();
            int z = buffer.readInt();
            NoppesUtil.openGUI(player, (Object)new GuiBook(player, ItemStack.func_77949_a((NBTTagCompound)Server.readNBT(buffer)), x, y, z));
        }
    }
}

