/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.CustomNpcs;

public class ServerCloneController {
    public static ServerCloneController Instance;
    private Map<Integer, Map<String, NBTTagCompound>> clones = this.loadClones();

    private Map<Integer, Map<String, NBTTagCompound>> loadClones() {
        try {
            File file = new File(this.getDir(), "clonednpcs.dat");
            if (!file.exists()) {
                return new HashMap<Integer, Map<String, NBTTagCompound>>();
            }
            return this.loadClones(file);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            try {
                File file = new File(this.getDir(), "clonednpcs.dat_old");
                return this.loadClones(file);
            }
            catch (Exception e2) {
                System.err.println(e2.getMessage());
                return new HashMap<Integer, Map<String, NBTTagCompound>>();
            }
        }
    }

    public File getDir() {
        return CustomNpcs.getWorldSaveDirectory();
    }

    private Map<Integer, Map<String, NBTTagCompound>> loadClones(File file) throws Exception {
        HashMap<Integer, Map<String, NBTTagCompound>> clones = new HashMap<Integer, Map<String, NBTTagCompound>>();
        NBTTagCompound nbttagcompound1 = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
        NBTTagList list = nbttagcompound1.func_150295_c("Data", 10);
        if (list == null) {
            return clones;
        }
        for (int i = 0; i < list.func_74745_c(); ++i) {
            HashMap<String, NBTTagCompound> tab;
            NBTTagCompound compound = list.func_150305_b(i);
            if (!compound.func_74764_b("ClonedDate")) {
                compound.func_74772_a("ClonedDate", System.currentTimeMillis());
                compound.func_74778_a("ClonedName", compound.func_74779_i("Name"));
            }
            if (!compound.func_74764_b("ClonedTab")) {
                compound.func_74768_a("ClonedTab", 1);
            }
            if ((tab = (HashMap<String, NBTTagCompound>)clones.get(compound.func_74762_e("ClonedTab"))) == null) {
                tab = new HashMap<String, NBTTagCompound>();
                clones.put(compound.func_74762_e("ClonedTab"), tab);
            }
            String name = compound.func_74779_i("ClonedName");
            int number = 1;
            while (tab.containsKey(name)) {
                name = String.format("%s%s", compound.func_74779_i("ClonedName"), ++number);
            }
            compound.func_74778_a("ClonedName", name);
            this.cleanTags(compound);
            tab.put(name, compound);
        }
        return clones;
    }

    public NBTTagCompound getCompound(String name, int tab) {
        if (!this.clones.containsKey(tab)) {
            return null;
        }
        for (NBTTagCompound tag : this.clones.get(tab).values()) {
            if (!name.equalsIgnoreCase(tag.func_74779_i("ClonedName"))) continue;
            return tag;
        }
        return null;
    }

    public void saveClones() {
        try {
            NBTTagList list = new NBTTagList();
            for (Map<String, NBTTagCompound> map : this.clones.values()) {
                for (NBTTagCompound nbt : map.values()) {
                    list.func_74742_a((NBTBase)nbt);
                }
            }
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74782_a("Data", (NBTBase)list);
            File file = new File(this.getDir(), "clonednpcs.dat_new");
            File file1 = new File(this.getDir(), "clonednpcs.dat_old");
            File file2 = new File(this.getDir(), "clonednpcs.dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbttagcompound, (OutputStream)new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public Map<String, NBTTagCompound> getClones(int tab) {
        if (!this.clones.containsKey(tab)) {
            return new HashMap<String, NBTTagCompound>();
        }
        return this.clones.get(tab);
    }

    public void removeClone(String name, int tab) {
        Map<String, NBTTagCompound> map = this.clones.get(tab);
        if (map == null) {
            return;
        }
        map.remove(name);
    }

    public String addClone(NBTTagCompound nbttagcompound, String name, int tab) {
        NBTTagCompound compound = this.getCompound(name, tab);
        if (compound != null) {
            this.clones.remove(compound);
        }
        nbttagcompound.func_74772_a("ClonedDate", System.currentTimeMillis());
        nbttagcompound.func_74778_a("ClonedName", name);
        nbttagcompound.func_74768_a("ClonedTab", tab);
        this.cleanTags(nbttagcompound);
        Map<String, NBTTagCompound> tabClones = this.clones.get(nbttagcompound.func_74762_e("ClonedTab"));
        if (tabClones == null) {
            tabClones = new HashMap<String, NBTTagCompound>();
            this.clones.put(nbttagcompound.func_74762_e("ClonedTab"), tabClones);
        }
        tabClones.put(name, nbttagcompound);
        this.saveClones();
        return name;
    }

    public void cleanTags(NBTTagCompound nbttagcompound) {
        NBTTagCompound adv;
        nbttagcompound.func_74768_a("ItemGiverId", 0);
        nbttagcompound.func_74768_a("TransporterId", -1);
        nbttagcompound.func_82580_o("StartPosNew");
        nbttagcompound.func_82580_o("StartPos");
        nbttagcompound.func_82580_o("MovingPathNew");
        nbttagcompound.func_82580_o("Pos");
        nbttagcompound.func_82580_o("Riding");
        if (!nbttagcompound.func_74764_b("ModRev")) {
            nbttagcompound.func_74768_a("ModRev", 1);
        }
        if (nbttagcompound.func_74764_b("TransformRole")) {
            adv = nbttagcompound.func_74775_l("TransformRole");
            adv.func_74768_a("TransporterId", -1);
            nbttagcompound.func_74782_a("TransformRole", (NBTBase)adv);
        }
        if (nbttagcompound.func_74764_b("TransformJob")) {
            adv = nbttagcompound.func_74775_l("TransformJob");
            adv.func_74768_a("ItemGiverId", 0);
            nbttagcompound.func_74782_a("TransformJob", (NBTBase)adv);
        }
        if (nbttagcompound.func_74764_b("TransformAI")) {
            adv = nbttagcompound.func_74775_l("TransformAI");
            adv.func_82580_o("StartPosNew");
            adv.func_82580_o("StartPos");
            adv.func_82580_o("MovingPathNew");
            nbttagcompound.func_74782_a("TransformAI", (NBTBase)adv);
        }
    }

    public boolean hasName(String name, int tab) {
        return this.getCompound(name, tab) != null;
    }
}

