/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import foxz.utils.Market;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleInterface;

public class RoleTrader
extends RoleInterface {
    public String marketName = "";
    public NpcMiscInventory inventoryCurrency = new NpcMiscInventory(36);
    public NpcMiscInventory inventorySold = new NpcMiscInventory(18);
    public boolean toSave = false;

    public RoleTrader(EntityNPCInterface npc) {
        super(npc);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74782_a("TraderCurrency", (NBTBase)this.inventoryCurrency.getToNBT());
        nbttagcompound.func_74782_a("TraderSold", (NBTBase)this.inventorySold.getToNBT());
        nbttagcompound.func_74778_a("TraderMarket", this.marketName);
        if (this.toSave && !this.npc.field_70170_p.field_72995_K) {
            Market.save(this, this.marketName);
        }
        this.toSave = false;
        return nbttagcompound;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.inventoryCurrency.setFromNBT(nbttagcompound.func_74775_l("TraderCurrency"));
        this.inventorySold.setFromNBT(nbttagcompound.func_74775_l("TraderSold"));
        this.marketName = nbttagcompound.func_74779_i("TraderMarket");
        try {
            Market.load(this, this.marketName);
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void interact(EntityPlayer player) {
        this.npc.say(player, this.npc.advanced.getInteractLine());
        try {
            Market.load(this, this.marketName);
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
        NoppesUtilServer.sendOpenGui(player, EnumGuiType.PlayerTrader, this.npc);
    }

    public boolean hasCurrency(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        for (ItemStack item : this.inventoryCurrency.items.values()) {
            if (item == null || !NoppesUtilPlayer.compareItems(item, itemstack, false)) continue;
            return true;
        }
        return false;
    }
}

