/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptEngine;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.scripted.ScriptEvent;
import noppes.npcs.scripted.ScriptNpc;
import noppes.npcs.scripted.ScriptWorld;
import noppes.npcs.scripted.constants.EntityType;
import noppes.npcs.scripted.constants.JobType;
import noppes.npcs.scripted.constants.RoleType;

public class DataScript {
    public Map<Integer, ScriptContainer> scripts = new HashMap<Integer, ScriptContainer>();
    private static final EntityType entities = new EntityType();
    private static final JobType jobs = new JobType();
    private static final RoleType roles = new RoleType();
    public String scriptLanguage = "ECMAScript";
    private EntityNPCInterface npc;
    public boolean enabled = false;
    public ScriptNpc dummyNpc;
    public ScriptWorld dummyWorld;
    public boolean clientNeedsUpdate = false;
    public boolean aiNeedsUpdate = false;
    public boolean hasInited = false;

    public DataScript(EntityNPCInterface npc) {
        this.npc = npc;
        if (npc instanceof EntityCustomNpc) {
            this.dummyNpc = new ScriptNpc((EntityCustomNpc)npc);
        }
        if (npc.field_70170_p instanceof WorldServer) {
            this.dummyWorld = new ScriptWorld((WorldServer)npc.field_70170_p);
        }
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.scripts = this.readScript(compound.func_150295_c("ScriptsContainers", 10));
        this.scriptLanguage = compound.func_74779_i("ScriptLanguage");
        this.enabled = compound.func_74767_n("ScriptEnabled");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74782_a("ScriptsContainers", (NBTBase)this.writeScript(this.scripts));
        compound.func_74778_a("ScriptLanguage", this.scriptLanguage);
        compound.func_74757_a("ScriptEnabled", this.enabled);
        return compound;
    }

    private Map<Integer, ScriptContainer> readScript(NBTTagList list) {
        HashMap<Integer, ScriptContainer> scripts = new HashMap<Integer, ScriptContainer>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compoundd = list.func_150305_b(i);
            ScriptContainer script = new ScriptContainer();
            script.readFromNBT(compoundd);
            scripts.put(compoundd.func_74762_e("Type"), script);
        }
        return scripts;
    }

    private NBTTagList writeScript(Map<Integer, ScriptContainer> scripts) {
        NBTTagList list = new NBTTagList();
        for (Integer type : scripts.keySet()) {
            NBTTagCompound compoundd = new NBTTagCompound();
            compoundd.func_74768_a("Type", type.intValue());
            ScriptContainer script = scripts.get(type);
            script.writeToNBT(compoundd);
            list.func_74742_a((NBTBase)compoundd);
        }
        return list;
    }

    public boolean callScript(EnumScriptType type, Object ... obs) {
        ScriptContainer script;
        if (this.aiNeedsUpdate) {
            this.npc.updateTasks();
            this.aiNeedsUpdate = false;
        }
        if (this.clientNeedsUpdate) {
            NoppesUtilServer.updateNpc(this.npc);
            this.clientNeedsUpdate = false;
        }
        if (!this.isEnabled()) {
            return false;
        }
        if (!this.hasInited) {
            this.hasInited = true;
            this.callScript(EnumScriptType.INIT, new Object[0]);
        }
        if ((script = this.scripts.get(type.ordinal())) == null || script.errored) {
            return false;
        }
        ScriptEngine engine = ScriptController.Instance.getEngineByName(this.scriptLanguage);
        if (engine == null) {
            return false;
        }
        int i = 0;
        while (i + 1 < obs.length) {
            engine.put(obs[i].toString(), obs[i + 1]);
            i += 2;
        }
        return this.callScript(engine, script);
    }

    public boolean isEnabled() {
        return this.enabled && ScriptController.HasStart && !this.npc.field_70170_p.field_72995_K;
    }

    private boolean callScript(ScriptEngine engine, ScriptContainer script) {
        if (!script.hasCode()) {
            return false;
        }
        engine.put("npc", this.dummyNpc);
        engine.put("world", this.dummyWorld);
        ScriptEvent result = (ScriptEvent)engine.get("event");
        if (result == null) {
            result = new ScriptEvent();
            engine.put("event", result);
        }
        engine.put("EntityType", entities);
        engine.put("RoleType", roles);
        engine.put("JobType", jobs);
        script.run(engine);
        if (this.clientNeedsUpdate) {
            NoppesUtilServer.updateNpc(this.npc);
            this.clientNeedsUpdate = false;
        }
        if (this.aiNeedsUpdate) {
            this.npc.updateTasks();
            this.aiNeedsUpdate = false;
        }
        return result.isCancelled();
    }

    public void setWorld(World world) {
        if (world instanceof WorldServer) {
            this.dummyWorld = new ScriptWorld((WorldServer)world);
        }
    }
}

