/*
 * Decompiled with CFR 0.152.
 */
package mysticores.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import mysticores.blocks.BlockHandler;
import mysticores.lib.Rarity;
import mysticores.worldgen.NetherGenHelper;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class WorldGenOres
implements IWorldGenerator {
    public static final WorldGenMinable adamantine = new WorldGenMinable(BlockHandler.BlockBase, 0, 3, Blocks.field_150348_b);
    public static final WorldGenMinable amethyst = new WorldGenMinable(BlockHandler.BlockBase, 1, 4, Blocks.field_150348_b);
    public static final WorldGenMinable iridium = new WorldGenMinable(BlockHandler.BlockBase, 2, 6, Blocks.field_150348_b);
    public static final WorldGenMinable mithril = new WorldGenMinable(BlockHandler.BlockBase, 3, 6, Blocks.field_150348_b);
    public static final WorldGenMinable tourmaline = new WorldGenMinable(BlockHandler.BlockBase, 4, 4, Blocks.field_150348_b);
    public static final WorldGenMinable topaz = new WorldGenMinable(BlockHandler.BlockBase, 5, 4, Blocks.field_150348_b);
    public static final WorldGenMinable verdite = new WorldGenMinable(BlockHandler.BlockBase, 6, 9, Blocks.field_150348_b);
    public static final WorldGenMinable agate = new WorldGenMinable(BlockHandler.BlockBase, 11, 4, Blocks.field_150348_b);
    public static final NetherGenHelper bloodstone = new NetherGenHelper(BlockHandler.BlockBase, 7, Rarity.BLOODSTONE + 1);
    public static final NetherGenHelper blackSoulstone = new NetherGenHelper(BlockHandler.BlockBase, 8, Rarity.BLACKSOULSTONE + 1);
    public static final NetherGenHelper blueSoulstone = new NetherGenHelper(BlockHandler.BlockBase, 9, Rarity.BLUESOULSTONE + 1);
    public static final NetherGenHelper redSoulstone = new NetherGenHelper(BlockHandler.BlockBase, 10, Rarity.REDSOULSTONE);

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (!world.field_73011_w.field_76575_d) {
            this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
        } else {
            this.generateNether(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    private void generateSurface(World world, Random random, int blockX, int blockZ) {
        int Zcoord;
        int Ycoord;
        int Xcoord;
        int i;
        for (i = 0; i < Rarity.ADAMANTINE; ++i) {
            Xcoord = blockX + random.nextInt(16);
            Ycoord = random.nextInt(13) + 3;
            Zcoord = blockZ + random.nextInt(16);
            adamantine.func_76484_a(world, random, Xcoord, Ycoord, Zcoord);
        }
        for (i = 0; i < Rarity.AGATE; ++i) {
            Xcoord = blockX + random.nextInt(16);
            Ycoord = random.nextInt(57) + 3;
            Zcoord = blockZ + random.nextInt(16);
            agate.func_76484_a(world, random, Xcoord, Ycoord, Zcoord);
        }
        for (i = 0; i < Rarity.AMETHYST; ++i) {
            Xcoord = blockX + random.nextInt(16);
            Ycoord = random.nextInt(57) + 3;
            Zcoord = blockZ + random.nextInt(16);
            amethyst.func_76484_a(world, random, Xcoord, Ycoord, Zcoord);
        }
        for (i = 0; i < Rarity.IRIDIUM; ++i) {
            Xcoord = blockX + random.nextInt(16);
            Ycoord = random.nextInt(9) + 3;
            Zcoord = blockZ + random.nextInt(16);
            iridium.func_76484_a(world, random, Xcoord, Ycoord, Zcoord);
        }
        for (i = 0; i < Rarity.MITHRIL; ++i) {
            Xcoord = blockX + random.nextInt(16);
            Ycoord = random.nextInt(61) + 3;
            Zcoord = blockZ + random.nextInt(16);
            mithril.func_76484_a(world, random, Xcoord, Ycoord, Zcoord);
        }
        for (i = 0; i < Rarity.TOPAZ; ++i) {
            Xcoord = blockX + random.nextInt(16);
            Ycoord = random.nextInt(57) + 3;
            Zcoord = blockZ + random.nextInt(16);
            topaz.func_76484_a(world, random, Xcoord, Ycoord, Zcoord);
        }
        for (i = 0; i < Rarity.TOURMALINE; ++i) {
            Xcoord = blockX + random.nextInt(16);
            Ycoord = random.nextInt(57) + 3;
            Zcoord = blockZ + random.nextInt(16);
            tourmaline.func_76484_a(world, random, Xcoord, Ycoord, Zcoord);
        }
        for (i = 0; i < Rarity.VERDITE; ++i) {
            Xcoord = blockX + random.nextInt(16);
            Ycoord = random.nextInt(20) + 80;
            Zcoord = blockZ + random.nextInt(16);
            verdite.func_76484_a(world, random, Xcoord, Ycoord, Zcoord);
        }
    }

    private void generateNether(World world, Random random, int i, int j) {
        int Ycoordinate;
        int Zcoordinate;
        int Xcoordinate;
        int j1;
        for (j1 = 0; j1 < 50; ++j1) {
            Xcoordinate = i + random.nextInt(16);
            Zcoordinate = j + random.nextInt(16);
            Ycoordinate = random.nextInt(256);
            bloodstone.func_76484_a(world, random, Xcoordinate, Ycoordinate, Zcoordinate);
        }
        for (j1 = 0; j1 < 50; ++j1) {
            Xcoordinate = i + random.nextInt(16);
            Zcoordinate = j + random.nextInt(16);
            Ycoordinate = random.nextInt(256);
            blackSoulstone.func_76484_a(world, random, Xcoordinate, Ycoordinate, Zcoordinate);
        }
        for (j1 = 0; j1 < 50; ++j1) {
            Xcoordinate = i + random.nextInt(16);
            Zcoordinate = j + random.nextInt(16);
            Ycoordinate = random.nextInt(256);
            blueSoulstone.func_76484_a(world, random, Xcoordinate, Ycoordinate, Zcoordinate);
        }
        for (j1 = 0; j1 < 50; ++j1) {
            Xcoordinate = i + random.nextInt(16);
            Zcoordinate = j + random.nextInt(16);
            Ycoordinate = random.nextInt(256);
            redSoulstone.func_76484_a(world, random, Xcoordinate, Ycoordinate, Zcoordinate);
        }
    }
}

