/*
 * Decompiled with CFR 0.152.
 */
package mysticworld.items;

import mysticworld.MysticWorld;
import mysticworld.items.ItemOrb;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemOrbAir
extends ItemOrb {
    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        player.func_71008_a(itemStack, this.func_77626_a(itemStack));
        return itemStack;
    }

    public int func_77626_a(ItemStack itemStack) {
        return 100;
    }

    public void func_77615_a(ItemStack itemStack, World world, EntityPlayer player, int time) {
        int charge = this.func_77626_a(itemStack) - time;
        if (charge > 0) {
            if (player.field_70122_E) {
                world.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "fire.ignite", 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
                if (!world.field_72995_K) {
                    player.func_70690_d(new PotionEffect(Potion.field_76430_j.func_76396_c(), 50, charge * 25 / this.func_77626_a(itemStack)));
                }
                itemStack.func_77972_a(1, (EntityLivingBase)player);
            }
            this.resetData(itemStack);
        }
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (par5) {
            entity.field_70143_R = 0.0f;
            this.chargeEffect(itemStack, world, entity);
        }
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        this.incrementData(stack, this.func_77626_a(stack) - count);
        this.spiralEffect(stack, player.field_70170_p, player, this.func_77626_a(stack) - count);
    }

    private void chargeEffect(ItemStack itemStack, World world, Entity player) {
        double particleX = player.field_70165_t - 0.5 + field_77697_d.nextDouble();
        double particleZ = player.field_70161_v - 0.5 + field_77697_d.nextDouble();
        MysticWorld.proxy.airFeetFX(world, particleX, player.field_70163_u, particleZ, 1.0f, 15);
    }

    private void incrementData(ItemStack itemStack, int charge) {
        itemStack.field_77990_d.func_74776_a("angle", itemStack.field_77990_d.func_74760_g("angle") + 0.2f);
        itemStack.field_77990_d.func_74780_a("radius", (double)charge * 0.025);
        if (itemStack.field_77990_d.func_74769_h("radius") > 2.5) {
            itemStack.field_77990_d.func_74780_a("radius", 2.5);
        }
        if (itemStack.field_77990_d.func_74760_g("angle") > 6.0f) {
            itemStack.field_77990_d.func_74776_a("angle", 0.0f);
        }
    }

    private void resetData(ItemStack itemStack) {
        itemStack.field_77990_d.func_74776_a("angle", 0.0f);
        itemStack.field_77990_d.func_74780_a("radius", 0.0);
    }

    private void spiralEffect(ItemStack itemStack, World world, EntityPlayer player, int charge) {
        double particleX = player.field_70165_t + (double)MathHelper.func_76134_b((float)itemStack.field_77990_d.func_74760_g("angle")) * itemStack.field_77990_d.func_74769_h("radius");
        double particleY = player.field_70163_u;
        double particleZ = player.field_70161_v + (double)MathHelper.func_76126_a((float)itemStack.field_77990_d.func_74760_g("angle")) * itemStack.field_77990_d.func_74769_h("radius");
        float particleScale = (float)charge * 5.0f / (float)this.func_77626_a(itemStack);
        MysticWorld.proxy.airFeetFX(world, particleX, particleY, particleZ, 1.0f + particleScale, 15);
    }
}

