/*
 * Decompiled with CFR 0.152.
 */
package mysticruins;

import cpw.mods.fml.common.registry.GameData;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import mysticruins.ChestFiller;
import mysticruins.MysticRuins;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.common.config.Configuration;

public class Config {
    public static Configuration config;
    public static int RuinRarity;
    public static int DunRarity;
    public static Set<Integer>[] allowId;
    public static final String[] allows;
    public static Set<BiomeDictionary.Type>[] allowType;
    public static List<DungeonHooks.DungeonMob> dungeonMobs;
    public static final String commonItems = "iron_pickaxe,iron_axe,iron_sword,iron_shovel,gold_ingot,iron_ingot";
    public static final String rareItems = "ender_pearl:4,diamond,emerald,golden_apple,gold_ingot,iron_ingot";

    public static void addDungeonMob(String name, int rarity) {
        for (DungeonHooks.DungeonMob mob : dungeonMobs) {
            if (!name.equals(mob.type)) continue;
            mob.field_76292_a += rarity;
            return;
        }
        dungeonMobs.add(new DungeonHooks.DungeonMob(rarity, name));
    }

    public static String getRandomDungeonMob(Random rand) {
        DungeonHooks.DungeonMob mob = (DungeonHooks.DungeonMob)WeightedRandom.func_76271_a((Random)rand, dungeonMobs);
        if (mob == null) {
            return "";
        }
        return mob.type;
    }

    public static void initialize(File file) {
        String[] mobs;
        config = new Configuration(file);
        MysticRuins.ENABLE = config.get("General", "Enable", true).getBoolean(true);
        for (String txt : mobs = config.get("DungeonMobs", "Spawner Type & Relative Chance", "Skeleton-50,Spider-50,Zombie-20,Cavepider-10,Blaze-1", "MobName-RelativeWeight").getString().split(",")) {
            String[] mob = txt.split("-");
            if (mob.length != 2) continue;
            try {
                Config.addDungeonMob(mob[0].trim(), Integer.parseInt(mob[1].trim()));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        Config.setChest("Common Items", commonItems, ChestFiller.valuables);
        Config.setChest("Rare Items", rareItems, ChestFiller.rares);
        StringBuilder build = new StringBuilder("Available biome tags are: ");
        for (BiomeDictionary.Type t : BiomeDictionary.Type.values()) {
            build.append(t);
            build.append(",");
        }
        config.addCustomCategoryComment("General", build.toString());
        RuinRarity = config.get("General", "Ruin Rarity", 200, "Chance per chunk : lower to make rarer").getInt();
        DunRarity = config.get("General", "Mystic Dungeon Rarity", 100, "Chance per chunk : lower to make rarer").getInt();
        for (int i = 0; i < allows.length; ++i) {
            String[] ID = config.get("General", allows[i], i < 2 ? "0,[2;10]" : "ALL,-WATER", i < 2 ? "Use [id1;id2] to add a range of id, prefix with - to exclude" : "Use ALL or * for all biomes, select with biome id or biome tags, prefix with - to exclude").getString().split(",");
            Config.allowId[i] = new HashSet<Integer>();
            if (i > 1) {
                Config.allowType[i - 2] = new HashSet<BiomeDictionary.Type>();
            }
            for (String txt : ID) {
                if (i > 1 && txt.startsWith("-")) {
                    txt = txt.substring(1).trim();
                    try {
                        allowId[i].remove(Integer.parseInt(txt));
                    }
                    catch (NumberFormatException e) {
                        try {
                            allowType[i - 2].remove(BiomeDictionary.Type.valueOf((String)txt.toUpperCase()));
                        }
                        catch (IllegalArgumentException l) {}
                    }
                    continue;
                }
                if (i < 2 && txt.contains("[") && txt.contains("]")) {
                    boolean remove = txt.trim().startsWith("-");
                    String[] results = txt.substring(txt.indexOf("[") + 1, txt.indexOf("]")).split(";");
                    if (results.length != 2) continue;
                    try {
                        int a = Integer.parseInt(results[0]);
                        int b = Integer.parseInt(results[1]);
                        if (a > b) {
                            int c = a;
                            a = b;
                            b = c;
                        }
                        for (int x = a; x <= b; ++x) {
                            if (remove) {
                                allowId[i].remove(x);
                                continue;
                            }
                            allowId[i].add(x);
                        }
                        continue;
                    }
                    catch (NumberFormatException n) {
                        continue;
                    }
                }
                try {
                    int j = Integer.parseInt(txt.trim());
                    allowId[i].add(j);
                    if (i <= 1) continue;
                    allowType[i - 2].addAll(Arrays.asList(BiomeDictionary.getTypesForBiome((BiomeGenBase)BiomeGenBase.func_150565_n()[j])));
                }
                catch (NumberFormatException e) {
                    if (i <= 1) continue;
                    if (txt.equals("*") || txt.equalsIgnoreCase("ALL")) {
                        for (int j = 0; j < BiomeGenBase.func_150565_n().length; ++j) {
                            allowId[i].add(j);
                        }
                        for (BiomeDictionary.Type t : BiomeDictionary.Type.values()) {
                            allowType[i - 2].add(t);
                        }
                        continue;
                    }
                    try {
                        BiomeDictionary.Type type = BiomeDictionary.Type.valueOf((String)txt.toUpperCase());
                        allowType[i - 2].add(type);
                        for (BiomeGenBase biome : BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type)) {
                            allowId[i].add(biome.field_76756_M);
                        }
                    }
                    catch (IllegalArgumentException l) {
                        // empty catch block
                    }
                }
            }
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static void setChest(String type, String list, List<ItemStack> valuables) {
        String[] items;
        for (String txt : items = config.get("Chests", type, list, "itemname:stacksize:damage").getString().split(",")) {
            Item id;
            int data;
            int amount;
            block8: {
                String[] item = txt.split(":");
                amount = 1;
                data = 0;
                try {
                    switch (item.length) {
                        case 3: {
                            data = Integer.parseInt(item[2]);
                        }
                        case 2: {
                            amount = Integer.parseInt(item[1]);
                        }
                        case 1: {
                            id = (Item)GameData.itemRegistry.get(item[0]);
                            break block8;
                        }
                    }
                }
                catch (NumberFormatException n) {}
                continue;
            }
            if (id == null || amount <= 0 || data < 0) continue;
            valuables.add(new ItemStack(id, amount, data));
        }
    }

    static {
        allowId = new HashSet[4];
        allows = new String[]{"Ruin allowed dimension id", "Dungeon allowed dimension id", "Ruin allowed biome id", "Dungeon allowed biome id"};
        allowType = new HashSet[2];
        dungeonMobs = new ArrayList<DungeonHooks.DungeonMob>();
    }
}

