/*
 * Decompiled with CFR 0.152.
 */
package cheatingessentials.api.module;

import cheatingessentials.mod.main.CheatingEssentials;
import cheatingessentials.mod.modulesystem.handler.ModuleManagement;
import cheatingessentials.mod.wrapper.ModuleCategories;

public abstract class Mod {
    protected String name = "unknown";
    protected String p = "cheatingessentials:";
    protected String description = "unknown";
    protected int keybind = 0;
    protected boolean enabled;
    protected ModuleCategories category;

    public Mod(ModuleCategories category) {
        this.category = category;
        CheatingEssentials.INSTANCE.logger.info("Loaded: " + this.getName() + " (" + this.getAlias() + ")" + " Category: " + (Object)((Object)this.getCategory()));
    }

    public void setKeybinding(int key) {
        this.keybind = key;
    }

    public void setCategory(ModuleCategories category) {
        this.category = category;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.p + this.getName().toLowerCase().replaceAll(" ", "");
    }

    public int getKeybind() {
        return this.keybind;
    }

    public String getDescription() {
        return this.description;
    }

    public ModuleCategories getCategory() {
        return this.category;
    }

    public boolean isActive() {
        return this.enabled;
    }

    public void onPlayerUpdate() {
    }

    public void onWorldUpdate() {
    }

    public void onTick() {
    }

    public void onWorldRender() {
    }

    public void onEnableMod() {
    }

    public void onDisableMod() {
    }

    public void reset() {
        this.onEnableMod();
        this.onDisableMod();
    }

    public void on() {
        this.enabled = true;
        this.onEnableMod();
        ModuleManagement.apiceMod.addActive(this);
    }

    public void off() {
        this.enabled = false;
        this.onDisableMod();
        ModuleManagement.apiceMod.removeActive(this);
    }

    public void toggle() {
        boolean bl = this.enabled = !this.enabled;
        if (this.isActive()) {
            this.onEnableMod();
            ModuleManagement.apiceMod.addActive(this);
        } else {
            this.onDisableMod();
            ModuleManagement.apiceMod.removeActive(this);
        }
    }
}

