/*
 * Decompiled with CFR 0.152.
 */
package cheatingessentials.mod.external.config.forge;

import cheatingessentials.mod.modulesystem.classes.BlockFinder;
import cheatingessentials.mod.modulesystem.classes.Fly;
import cheatingessentials.mod.modulesystem.classes.Speed;
import cheatingessentials.mod.modulesystem.classes.Step;
import cheatingessentials.mod.wrapper.Wrapper;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class GeneralConfiguration {
    private static volatile GeneralConfiguration INSTANCE = new GeneralConfiguration();
    public Configuration configuration;
    public float flySpeedValue;
    public float stepHeightValue;
    public double speedValue;
    public int bfrValue;

    public GeneralConfiguration() {
        File path = new File(Wrapper.INSTANCE.minecraft().field_71412_D, "/config/Cheating-Essentials/General-Config.cfg");
        this.configuration = new Configuration(path);
        this.configuration.load();
        this.configuration.addCustomCategoryComment("general", "General Cheating Essentials values. This change when you use commands but you can change them here too");
        Property flySpeed = this.configuration.get("general", "flySpeed", (double)Fly.FLY_SPEED);
        Property stepHeight = this.configuration.get("general", "stepHeight", (double)Step.DEFAULT_STEP_HEIGHT);
        Property speed = this.configuration.get("general", "speedValue", Speed.SPEED_VALUE);
        Property blockFinderRadius = this.configuration.get("general", "blockFinderRadius", BlockFinder.BLOCK_RADIUS);
        flySpeed.comment = "Player Fly speed when <Fly> module is enabled.";
        stepHeight.comment = "Player step height when <Step> module is enabled.";
        speed.comment = "Player speed when <Speed> module is enabled.";
        blockFinderRadius.comment = "Block Finder block highlight radius.";
        this.flySpeedValue = (float)flySpeed.getDouble((double)Fly.FLY_SPEED);
        this.stepHeightValue = (float)stepHeight.getDouble((double)Step.DEFAULT_STEP_HEIGHT);
        this.speedValue = speed.getDouble(Speed.SPEED_VALUE);
        this.bfrValue = blockFinderRadius.getInt(BlockFinder.BLOCK_RADIUS);
        this.apply();
        this.configuration.save();
    }

    private void apply() {
        Fly.FLY_SPEED = this.flySpeedValue;
        Step.DEFAULT_STEP_HEIGHT = this.stepHeightValue;
        Speed.SPEED_VALUE = this.speedValue;
        BlockFinder.BLOCK_RADIUS = this.bfrValue;
    }

    public static GeneralConfiguration instance() {
        return INSTANCE;
    }
}

