/*
 * Decompiled with CFR 0.152.
 */
package cheatingessentials.mod.modulesystem.classes;

import cheatingessentials.api.module.Mod;
import cheatingessentials.mod.internal.CEBlockCoord;
import cheatingessentials.mod.internal.CEColor;
import cheatingessentials.mod.util.GLUtils;
import cheatingessentials.mod.wrapper.ModuleCategories;
import cheatingessentials.mod.wrapper.Wrapper;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.block.Block;

public class BlockFinder
extends Mod {
    public int size = 0;
    public int timer = 0;
    public static BlockFinder instance;
    public static CopyOnWriteArrayList<Integer> idEspList;
    public static CopyOnWriteArrayList<Long> metaEspList;
    public static CopyOnWriteArrayList<String> idEspStrings;
    public static CEBlockCoord[] espBlocks;
    public static CEColor[] espColors;
    public static int BLOCK_RADIUS;

    public BlockFinder() {
        super(ModuleCategories.RENDER);
        instance = this;
    }

    @Override
    public String getName() {
        return "Block Finder";
    }

    @Override
    public String getDescription() {
        return "Allows to the player to find a specific kind of block easily when added to a list (55 block radius)";
    }

    @Override
    public void onWorldRender() {
        ++this.timer;
        if (this.timer >= 35) {
            this.refresh();
            this.timer = 0;
        }
        for (int cur = 0; cur < this.size; ++cur) {
            CEBlockCoord curBlock = espBlocks[cur];
            CEColor color = espColors[Block.func_149682_b((Block)Wrapper.INSTANCE.world().func_147439_a((int)curBlock.getX(), (int)curBlock.getY(), (int)curBlock.getZ()))];
            if (color != null) {
                color = CEColor.colorToGL(color);
            } else {
                color = new CEColor(0.0f, 255.0f, 0.0f);
                color = CEColor.colorToGL(color);
            }
            GLUtils.startDrawingESPs(curBlock.getDeltaX(), curBlock.getDeltaY(), curBlock.getDeltaZ(), color.R, color.G, color.B);
        }
    }

    public void addBlock(int id, int r, int g, int b) {
        idEspList.add(id);
        idEspStrings.add(id + "-" + r + "-" + g + "-" + b);
        BlockFinder.espColors[id] = new CEColor(r, g, b);
    }

    public void addBlock(int id, int meta, int r, int g, int b) {
        long block = this.mergedId(id, meta);
        metaEspList.add(block);
        idEspStrings.add(id + "-" + r + "-" + g + "-" + b);
        BlockFinder.espColors[id] = new CEColor(r, g, b);
    }

    public void removeBlock(int id) {
        int index = idEspList.indexOf(id);
        int index2 = idEspStrings.indexOf(id + "-" + (int)BlockFinder.espColors[id].R + "-" + (int)BlockFinder.espColors[id].G + "-" + (int)BlockFinder.espColors[id].B);
        idEspList.remove(index);
        idEspStrings.remove(index2);
        BlockFinder.espColors[id] = null;
    }

    public void removeBlock(int id, int meta) {
        long block = this.mergedId(id, meta);
        int index = idEspStrings.indexOf(id + "-" + (int)BlockFinder.espColors[id].R + "-" + (int)BlockFinder.espColors[id].G + "-" + (int)BlockFinder.espColors[id].B);
        metaEspList.remove(block);
        idEspStrings.remove(index);
        BlockFinder.espColors[id] = null;
    }

    public void removeAll() {
        idEspList.clear();
        metaEspList.clear();
        idEspStrings.clear();
        espColors = new CEColor[10000000];
    }

    public String list() {
        String idString = "Esp Blocks: ";
        Iterator<Number> i$ = idEspList.iterator();
        while (i$.hasNext()) {
            int id = i$.next();
            idString = idString + System.lineSeparator() + id;
        }
        i$ = metaEspList.iterator();
        while (i$.hasNext()) {
            long mergedId = (Long)i$.next();
            idString = idString + System.lineSeparator() + this.idFromMerged(mergedId) + ":" + this.metaFromMergedId(mergedId);
        }
        return idString;
    }

    private long mergedId(int id, int meta) {
        return (long)id << 32 | (long)meta & 0xFFFFFFFFL;
    }

    private int idFromMerged(long mergedId) {
        return (int)(mergedId >> 32);
    }

    private int metaFromMergedId(long mergedId) {
        return (int)mergedId;
    }

    public void refresh() {
        this.size = 0;
        int radius = BLOCK_RADIUS;
        for (int y = 0; y < 128; ++y) {
            for (int x = 0; x < radius; ++x) {
                for (int z = 0; z < radius; ++z) {
                    int cX = (int)Wrapper.INSTANCE.minecraft().field_71439_g.field_70165_t - radius / 2 + x;
                    int cY = y;
                    int cZ = (int)Wrapper.INSTANCE.minecraft().field_71439_g.field_70161_v - radius / 2 + z;
                    Block blockpos = Wrapper.INSTANCE.world().func_147439_a(cX, cY, cZ);
                    int ids = Block.func_149682_b((Block)blockpos);
                    if (idEspList.contains(ids)) {
                        BlockFinder.espBlocks[this.size++] = new CEBlockCoord(cX, cY, cZ);
                        continue;
                    }
                    int meta = Wrapper.INSTANCE.world().func_72805_g(cX, cY, cZ);
                    long block = this.mergedId(ids, meta);
                    if (!metaEspList.contains(block)) continue;
                    BlockFinder.espBlocks[this.size++] = new CEBlockCoord(cX, cY, cZ);
                }
            }
        }
    }

    static {
        idEspList = new CopyOnWriteArrayList();
        metaEspList = new CopyOnWriteArrayList();
        idEspStrings = new CopyOnWriteArrayList();
        espBlocks = new CEBlockCoord[10000000];
        espColors = new CEColor[10000000];
        BLOCK_RADIUS = 55;
    }
}

