/*
 * Decompiled with CFR 0.152.
 */
package cz.ondraster.bettersleeping.client.gui;

import baubles.api.BaublesApi;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cz.ondraster.bettersleeping.Config;
import cz.ondraster.bettersleeping.client.gui.OptionalGuiOverlay;
import cz.ondraster.bettersleeping.item.ItemClass;
import cz.ondraster.bettersleeping.logic.MinecraftTime;
import cz.ondraster.bettersleeping.player.SleepingProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class SleepOverlay
extends OptionalGuiOverlay {
    public static final int BTN_WIDTH = 8;
    public static final int BAR_WIDTH = 32;
    public static final int MAX_OFFSET = 24;
    public static final int BAR_HEIGHT = 8;
    public static final int ICON_WIDTH = 16;
    public static final int ICON_HEIGHT = 16;
    public static SleepingProperty playerProperty;

    @SubscribeEvent
    public void onGuiRender(RenderGameOverlayEvent event) {
        if (event.type != RenderGameOverlayEvent.ElementType.EXPERIENCE && event.type != RenderGameOverlayEvent.ElementType.JUMPBAR || event.isCancelable()) {
            return;
        }
        if (playerProperty == null) {
            return;
        }
        TextureManager mgr = Minecraft.func_71410_x().field_71446_o;
        mgr.func_110577_a(new ResourceLocation("bettersleeping", "textures/gui/bar.png"));
        this.func_73729_b(Config.guiOffsetLeft, Config.guiOffsetTop, 0, 0, 32, 8);
        int takenPercent = (int)((double)SleepOverlay.playerProperty.sleepCounter / (double)Config.maximumSleepCounter * 24.0);
        if (takenPercent > 24) {
            takenPercent = 24;
        }
        this.func_73729_b(4 + takenPercent, Config.guiOffsetTop, 0, 8, 8, 8);
        ItemStack bed = new ItemStack(Items.field_151104_aV);
        mgr.func_110577_a(TextureMap.field_110576_c);
        this.func_94065_a(Config.guiOffsetLeft + 32 + 4, Config.guiOffsetTop - 4, Items.field_151104_aV.getIcon(bed, 1), 16, 16);
        this.renderTimeOverlay();
    }

    @Override
    @Optional.Method(modid="Baubles|API")
    public void renderTimeOverlay() {
        if (Config.enableRingWatch) {
            IInventory baubles = BaublesApi.getBaubles((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            for (int i = 0; i < baubles.func_70302_i_(); ++i) {
                ItemStack itemStack = baubles.func_70301_a(i);
                if (itemStack == null || itemStack.func_77973_b() != ItemClass.itemRingWatch) continue;
                MinecraftTime time = MinecraftTime.getFromWorldTime(Minecraft.func_71410_x().field_71441_e.func_72820_D());
                this.func_73732_a(Minecraft.func_71410_x().field_71466_p, time.toString(), Config.guiOffsetLeft + 16, Config.guiOffsetTop + 16, 0xFFFFFF);
                return;
            }
        }
    }
}

