/*
 * Decompiled with CFR 0.152.
 */
package cz.ondraster.bettersleeping;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cz.ondraster.bettersleeping.Config;
import cz.ondraster.bettersleeping.client.gui.SleepOverlay;
import cz.ondraster.bettersleeping.logic.Alarm;
import cz.ondraster.bettersleeping.logic.AlternateSleep;
import cz.ondraster.bettersleeping.network.MessageUpdateTiredness;
import cz.ondraster.bettersleeping.network.Network;
import cz.ondraster.bettersleeping.player.SleepingProperty;
import cz.ondraster.bettersleeping.proxy.ProxyCommon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;

@Mod(modid="bettersleeping", name="Better Sleeping", version="BS_1710")
public class BetterSleeping {
    public static final String MODID = "bettersleeping";
    public static final String NAME = "Better Sleeping";
    public static final String AUTHOR = "OndraSter";
    public static final String VERSION = "BS_1710";
    @SidedProxy(clientSide="cz.ondraster.bettersleeping.proxy.ProxyClient", serverSide="cz.ondraster.bettersleeping.proxy.ProxyCommon")
    public static ProxyCommon proxy;
    @Mod.Instance
    public static BetterSleeping INSTANCE;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        Config c = new Config(event.getSuggestedConfigurationFile().getAbsolutePath());
        proxy.preinit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
    }

    @SubscribeEvent
    public void onPreWorldTick(TickEvent.WorldTickEvent event) {
        if (!(event.world instanceof WorldServer)) {
            return;
        }
        WorldServer world = (WorldServer)event.world;
        if (world.func_73056_e()) {
            Alarm.sleepWorld((World)world);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        SleepingProperty property = null;
        if (event.player.field_70170_p.field_72995_K) {
            SleepOverlay.playerProperty = SleepingProperty.get(event.player);
            return;
        }
        if (Config.enableSleepCounter) {
            property = SleepingProperty.get(event.player);
            ++property.ticksSinceUpdate;
            if (property.ticksSinceUpdate >= Config.ticksPerSleepCounter) {
                property.ticksSinceUpdate = 0;
                --property.sleepCounter;
                if (property.sleepCounter < 0L) {
                    property.sleepCounter = 0L;
                }
            }
            if ((double)Math.abs(property.sleepCounter - property.lastUpdate) / (double)Config.maximumSleepCounter > 0.041666666666666664 && event.player instanceof EntityPlayerMP) {
                Network.networkChannel.sendTo((IMessage)new MessageUpdateTiredness(property.sleepCounter), (EntityPlayerMP)event.player);
                property.lastUpdate = property.sleepCounter;
            }
        }
        if (Config.enableDebuffs && Config.enableSleepCounter) {
            if (property.sleepCounter <= (long)Config.slownessDebuff && event.player.func_70660_b(Potion.field_76421_d) == null) {
                event.player.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 20));
            }
            if (property.sleepCounter <= (long)Config.visionDebuff && event.player.func_70660_b(Potion.field_76440_q) == null) {
                event.player.func_70690_d(new PotionEffect(Potion.field_76440_q.func_76396_c(), 20));
            }
            if (property.sleepCounter == 0L && !event.player.func_70608_bn()) {
                event.player.func_145747_a((IChatComponent)new ChatComponentTranslation("msg.tooTired", new Object[0]));
                event.player.func_71018_a((int)event.player.field_70165_t, (int)event.player.field_70163_u, (int)event.player.field_70161_v);
            }
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer && SleepingProperty.get((EntityPlayer)event.entity) == null) {
            SleepingProperty.register((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onPlayerSleepInBed(PlayerSleepInBedEvent event) {
        if (Config.enableSleepCounter) {
            SleepingProperty property = SleepingProperty.get(event.entityPlayer);
            if (property.sleepCounter >= (long)Config.maximumSleepCounter) {
                event.entityPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("msg.notTired", new Object[0]));
                event.result = EntityPlayer.EnumStatus.OTHER_PROBLEM;
            }
        }
        if (event.entityPlayer.field_70170_p.field_72995_K) {
            return;
        }
        int sleeping = AlternateSleep.getSleepingPeopleInWorld(event.entityPlayer.field_70170_p);
        if ((double)sleeping / (double)event.entityPlayer.field_70170_p.field_73010_i.size() >= Config.percentPeopleToSleep) {
            Alarm.sleepWorld(event.entityPlayer.field_70170_p);
        }
    }
}

