/*
 * Decompiled with CFR 0.152.
 */
package cz.ondraster.bettersleeping.logic;

import cz.ondraster.bettersleeping.Config;
import cz.ondraster.bettersleeping.logic.MinecraftTime;
import cz.ondraster.bettersleeping.player.SleepingProperty;
import cz.ondraster.bettersleeping.tileentity.TileEntityAlarm;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class Alarm {
    public static final int MINUTES_IN_HOUR = 50;

    public static List<TileEntityAlarm> getAllAlarms(List<EntityPlayer> playerEntities) {
        ArrayList<TileEntityAlarm> alarms = new ArrayList<TileEntityAlarm>();
        for (EntityPlayer player : playerEntities) {
            TileEntityAlarm alarm = Alarm.findNearbyAlarm(player);
            if (alarm == null) continue;
            alarms.add(alarm);
        }
        return alarms;
    }

    public static TileEntityAlarm findNearbyAlarm(EntityPlayer player) {
        World world = player.field_70170_p;
        for (double x = player.field_70165_t - 2.0; x < player.field_70165_t + 2.0; x += 1.0) {
            for (double y = player.field_70163_u - 1.0; y < player.field_70163_u + 2.0; y += 1.0) {
                for (double z = player.field_70161_v - 2.0; z < player.field_70161_v + 2.0; z += 1.0) {
                    TileEntity tileEntity = world.func_147438_o((int)x, (int)y, (int)z);
                    if (!(tileEntity instanceof TileEntityAlarm)) continue;
                    return (TileEntityAlarm)tileEntity;
                }
            }
        }
        return null;
    }

    public static void sleepWorld(World world) {
        long i;
        List<TileEntityAlarm> alarms = Alarm.getAllAlarms(world.field_73010_i);
        int mntTotal = 0;
        for (TileEntityAlarm alarm : alarms) {
            mntTotal = (int)((long)mntTotal + MinecraftTime.extrapolateTime(alarm.getHour(), alarm.getMinute()));
        }
        mntTotal = alarms.size() != 0 ? (mntTotal /= alarms.size()) : 0;
        long curTime = world.func_72820_D();
        if (alarms.size() == 0) {
            i = curTime + 24000L;
            i -= i % 24000L;
            i += (long)Config.defaultWakeUpTime;
            world.func_72877_b(i += (long)world.field_73012_v.nextInt(Config.oversleepWithoutAlarm));
        } else {
            i = curTime;
            if ((long)mntTotal <= curTime % 24000L) {
                i += 24000L;
            }
            i -= i % 24000L;
            i += (long)mntTotal;
            world.func_72877_b(i += (long)world.field_73012_v.nextInt(Config.oversleepWithAlarm / alarms.size()));
        }
        MinecraftTime time = MinecraftTime.getFromWorldTime(world.func_72820_D());
        for (EntityPlayer player : world.field_73010_i) {
            if (player.func_70608_bn()) {
                player.func_70999_a(false, false, true);
                if (Config.enableSleepCounter) {
                    SleepingProperty property = SleepingProperty.get(player);
                    property.sleepCounter = (long)((double)property.sleepCounter + (double)(world.func_72820_D() - curTime) * Config.sleepPerSleptTick);
                }
            }
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("msg.wakeUp", new Object[]{time.toString()}));
        }
        if (Config.chanceToStopRain >= world.field_73012_v.nextDouble()) {
            world.field_73011_w.resetRainAndThunder();
        }
    }

    public static boolean canNotSleep(EntityPlayer player) {
        return false;
    }

    public static boolean canSleep(EntityPlayer player) {
        SleepingProperty property = SleepingProperty.get(player);
        return property.sleepCounter == 0L && Config.enableDebuffs && Config.enableSleepCounter && Config.sleepOnGround;
    }
}

