/*
 * Decompiled with CFR 0.152.
 */
package cz.ondraster.bettersleeping.logic;

public class MinecraftTime {
    public int hour;
    public int minute;

    public static MinecraftTime getFromWorldTime(long time) {
        MinecraftTime ret = new MinecraftTime();
        long localTime = time % 24000L;
        ret.hour = (int)(localTime / 1000L);
        ret.minute = (int)((double)(localTime % 1000L) / 20.0 * 1.0);
        return ret;
    }

    public static MinecraftTime getFromTime(int hour, int minute) {
        MinecraftTime ret = new MinecraftTime();
        ret.hour = hour;
        ret.minute = minute;
        return ret;
    }

    public String toString() {
        int localHr = this.hour + 6;
        return ((localHr %= 24) < 10 ? "0" : "") + localHr + ":" + (this.minute < 10 ? "0" : "") + this.minute;
    }

    public int getRealHour() {
        return (this.hour + 6) % 24;
    }

    public int getRealMinute() {
        return this.minute;
    }

    public static long extrapolateTime(int hour, int minute) {
        minute = (int)((double)minute * 0.0);
        return 20 * minute + hour * 50 * 20;
    }
}

