/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.stackie.handler;

import com.github.lunatrius.stackie.handler.ConfigurationHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.item.ItemStack;

public abstract class StackingHandler {
    public static final int MAXIMUM_STACKSIZE = 2048;
    public static final int MAXIMUM_EXPERIENCE = 1024;
    private double weightL = -1.0;
    private double weightR = -1.0;

    protected boolean stackEntities(Entity entityL, Entity entityR) {
        EntityType typeR;
        EntityType typeL = this.getType(entityL);
        if (typeL == (typeR = this.getType(entityR)) && this.isEqualPosition(entityL, entityR)) {
            boolean merged;
            switch (typeL) {
                case ITEM: {
                    merged = this.stackItems((EntityItem)entityL, (EntityItem)entityR);
                    break;
                }
                case EXPERIENCEORB: {
                    merged = this.stackExperience((EntityXPOrb)entityL, (EntityXPOrb)entityR);
                    break;
                }
                default: {
                    return false;
                }
            }
            if (merged) {
                entityR.func_70106_y();
                double totalWeight = this.weightL + this.weightR;
                this.weightL /= totalWeight;
                this.weightR /= totalWeight;
                double x = entityL.field_70165_t * this.weightL + entityR.field_70165_t * this.weightR;
                double y = entityL.field_70163_u * this.weightL + entityR.field_70163_u * this.weightR;
                double z = entityL.field_70161_v * this.weightL + entityR.field_70161_v * this.weightR;
                entityL.func_70107_b(x, y, z);
                entityL.field_70159_w = entityL.field_70159_w * this.weightL + entityR.field_70159_w * this.weightR;
                entityL.field_70181_x = entityL.field_70181_x * this.weightL + entityR.field_70181_x * this.weightR;
                entityL.field_70179_y = entityL.field_70179_y * this.weightL + entityR.field_70179_y * this.weightR;
            }
            return merged;
        }
        return false;
    }

    private boolean stackItems(EntityItem entityItemL, EntityItem entityItemR) {
        ItemStack itemStackR;
        ItemStack itemStackL = entityItemL.func_92059_d();
        if (!this.areItemStacksValid(itemStackL, itemStackR = entityItemR.func_92059_d())) {
            return false;
        }
        this.weightL = itemStackL.field_77994_a;
        this.weightR = itemStackR.field_77994_a;
        int itemsIn = Math.min(2048 - itemStackL.field_77994_a, itemStackR.field_77994_a);
        itemStackL.field_77994_a += itemsIn;
        itemStackR.field_77994_a -= itemsIn;
        entityItemL.func_92058_a(itemStackL);
        entityItemR.func_92058_a(itemStackR);
        entityItemL.field_70292_b = Math.min(entityItemL.field_70292_b, entityItemR.field_70292_b);
        return itemStackR.field_77994_a <= 0;
    }

    private boolean areItemStacksValid(ItemStack itemStackL, ItemStack itemStackR) {
        if (itemStackL == null || itemStackR == null) {
            return false;
        }
        if (!itemStackL.func_77985_e()) {
            return false;
        }
        if (itemStackL.field_77994_a <= 0 || itemStackR.field_77994_a <= 0) {
            return false;
        }
        if (itemStackL.func_77973_b() != itemStackR.func_77973_b()) {
            return false;
        }
        if (itemStackL.func_77952_i() != itemStackR.func_77952_i()) {
            return false;
        }
        if (itemStackL.func_77978_p() == null && itemStackR.func_77978_p() == null) {
            return true;
        }
        return itemStackL.func_77978_p() != null && itemStackL.func_77978_p().equals((Object)itemStackR.func_77978_p());
    }

    private boolean stackExperience(EntityXPOrb entityExpOrbL, EntityXPOrb entityExpOrbR) {
        this.weightL = entityExpOrbL.func_70526_d();
        this.weightR = entityExpOrbR.func_70526_d();
        int experienceIn = Math.min(1024 - entityExpOrbL.field_70530_e, entityExpOrbR.field_70530_e);
        entityExpOrbL.field_70530_e += experienceIn;
        entityExpOrbR.field_70530_e -= experienceIn;
        entityExpOrbL.field_70531_b = Math.min(entityExpOrbL.field_70531_b, entityExpOrbR.field_70531_b);
        return entityExpOrbR.field_70530_e <= 0;
    }

    protected EntityType getType(Entity entity) {
        if (ConfigurationHandler.stackItems && entity instanceof EntityItem) {
            return EntityType.ITEM;
        }
        if (ConfigurationHandler.stackExperience && entity instanceof EntityXPOrb) {
            return EntityType.EXPERIENCEORB;
        }
        return EntityType.OTHER;
    }

    private boolean isEqualPosition(Entity a, Entity b) {
        return this.isEqual(a.field_70165_t, b.field_70165_t) && this.isEqual(a.field_70163_u, b.field_70163_u) && this.isEqual(a.field_70161_v, b.field_70161_v);
    }

    private boolean isEqual(double a, double b) {
        return this.isEqual(a, b, ConfigurationHandler.distance);
    }

    private boolean isEqual(double a, double b, double epsilon) {
        return Math.abs(a - b) < epsilon;
    }

    protected static enum EntityType {
        ITEM(EntityItem.class),
        EXPERIENCEORB(EntityXPOrb.class),
        OTHER(null);

        public final Class clazz;

        private EntityType(Class clazz) {
            this.clazz = clazz;
        }
    }
}

