/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.stackie.handler;

import com.github.lunatrius.stackie.handler.ConfigurationHandler;
import com.github.lunatrius.stackie.handler.StackingHandler;
import com.github.lunatrius.stackie.reference.Reference;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class Ticker
extends StackingHandler {
    public static final Ticker INSTANCE = new Ticker();
    private MinecraftServer server = null;
    private int ticks = -1;

    private Ticker() {
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (--this.ticks < 0) {
            if (this.server != null && this.server.field_71305_c != null) {
                this.processWorlds(this.server.field_71305_c);
            }
            this.ticks = ConfigurationHandler.interval;
        }
    }

    public void setServer(MinecraftServer server) {
        this.server = server;
    }

    private void processWorlds(WorldServer[] worldServers) {
        for (WorldServer world : worldServers) {
            ArrayList<Entity> entityList = new ArrayList<Entity>();
            for (int i = 0; i < world.field_72996_f.size(); ++i) {
                if (this.getType((Entity)world.field_72996_f.get(i)) == StackingHandler.EntityType.OTHER) continue;
                entityList.add((Entity)world.field_72996_f.get(i));
            }
            if (entityList.size() < 2 || entityList.size() > ConfigurationHandler.stackLimit) continue;
            try {
                this.stackEntities(entityList);
            }
            catch (Exception e) {
                Reference.logger.error("Could not stack entities!", (Throwable)e);
            }
        }
    }

    private void stackEntities(List<Entity> entityList) {
        ListIterator<Entity> iteratorL = entityList.listIterator();
        while (iteratorL.hasNext()) {
            Entity entityL = iteratorL.next();
            if (entityL.field_70128_L) continue;
            ListIterator<Entity> iteratorR = entityList.listIterator(iteratorL.nextIndex());
            while (iteratorR.hasNext()) {
                Entity entityR = iteratorR.next();
                if (entityR.field_70128_L) continue;
                this.stackEntities(entityL, entityR);
            }
        }
    }
}

