/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.stackie.proxy;

import com.github.lunatrius.core.version.VersionChecker;
import com.github.lunatrius.stackie.command.StackieCommand;
import com.github.lunatrius.stackie.handler.ConfigurationHandler;
import com.github.lunatrius.stackie.handler.SpawnHandler;
import com.github.lunatrius.stackie.handler.Ticker;
import com.github.lunatrius.stackie.reference.Reference;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.registry.GameData;

public abstract class CommonProxy {
    public void preInit(FMLPreInitializationEvent event) {
        Reference.logger = event.getModLog();
        ConfigurationHandler.init(event.getSuggestedConfigurationFile());
        VersionChecker.registerMod((ModMetadata)event.getModMetadata(), (String)"11.14.0.1289-1.8");
    }

    public void init(FMLInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)Ticker.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)SpawnHandler.INSTANCE);
    }

    public void postInit(FMLPostInitializationEvent event) {
        for (String info : ConfigurationHandler.stackSizes) {
            String[] parts = info.split("-");
            if (parts.length != 2) continue;
            try {
                String uniqueName = parts[0];
                int stackSize = MathHelper.func_76125_a((int)Integer.parseInt(parts[1], 10), (int)1, (int)64);
                Item item = (Item)GameData.getItemRegistry().func_82594_a((Object)uniqueName);
                if (item == null) continue;
                item.func_77625_d(stackSize);
            }
            catch (Exception e) {
                Reference.logger.error("Invalid format?", (Throwable)e);
            }
        }
    }

    public void serverStarting(FMLServerStartingEvent event) {
        Ticker.INSTANCE.setServer(event.getServer());
        event.registerServerCommand((ICommand)new StackieCommand());
    }

    public void serverStopping(FMLServerStoppingEvent event) {
        Ticker.INSTANCE.setServer(null);
    }
}

