/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.gen;

import java.util.Random;
import mod.lucky.Lucky;
import mod.lucky.block.BlockLuckyBlock;
import mod.lucky.util.CustomStructures;
import mod.lucky.util.StructureUtil;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.IWorldGenerator;

public class LuckyGenerator
implements IWorldGenerator {
    public int spawnrate = 300;
    public int structureChance = 2;

    public void setSpawnrate(int spawnrate) {
        this.spawnrate = spawnrate;
    }

    public void setStructureChance(int structureChance) {
        this.structureChance = structureChance;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        CustomStructures.setRandom(random);
        switch (world.field_73011_w.func_177502_q()) {
            case -1: {
                if (this.spawnrate == 0 || random.nextInt(this.spawnrate / 3 == 0 ? 1 : this.spawnrate / 3) != 0) break;
                this.generateNether(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case 0: {
                if (this.spawnrate == 0 || random.nextInt(this.spawnrate) != 0) break;
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case 1: {
                if (this.spawnrate == 0 || random.nextInt(this.spawnrate / 8 == 0 ? 1 : this.spawnrate / 8) != 0) break;
                this.generateEnd(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    private void generateNether(World world, Random random, int x, int z) {
        int y = 64;
        CustomStructures.makeSurfaceLuckyBlock(world, x += random.nextInt(16) + 8, y, z += random.nextInt(16) + 8, -20, 20);
    }

    private void generateSurface(World world, Random random, int x, int z) {
        int y = 128;
        this.makeSurfaceLuckyBlockOrStructure(world, random, x += random.nextInt(16) + 8, y, z += random.nextInt(16) + 8);
    }

    private void generateEnd(World world, Random random, int x, int z) {
        int y = 100;
        CustomStructures.makeSurfaceLuckyBlock(world, x += random.nextInt(16) + 8, y, z += random.nextInt(16) + 8, -20, 20);
    }

    private boolean makeSurfaceLuckyBlockOrStructure(World world, Random random, int posX, int posY, int posZ) {
        int newPosY = StructureUtil.getSurfacePosY(world, posX, posY, posZ);
        if (newPosY == -1) {
            return false;
        }
        if (((BlockLuckyBlock)Lucky.lucky_block).canBlockStay(world, new BlockPos(posX, newPosY, posZ))) {
            if (this.structureChance != 0 && random.nextInt(this.structureChance) == 0) {
                if (random.nextInt(2) == 0) {
                    CustomStructures.makeLuckyGenStructure(world, random, posX, newPosY, posZ);
                } else {
                    CustomStructures.makeUnluckyGenStructure(world, random, posX, newPosY, posZ);
                }
                return true;
            }
            return StructureUtil.setLuckyBlock(world, posX, newPosY, posZ, MathHelper.func_76136_a((Random)random, (int)-20, (int)20));
        }
        return false;
    }
}

