/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.gen.structure;

import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class Structure {
    public int length;
    public int width;
    public int height;
    public int[][][] blocks;
    public int[][][] blockData;
    public boolean isStructureTooLarge = false;
    public File structureFile;
    public String structureFileName;
    public String structureID;
    public int centerX = 0;
    public int centerY = 0;
    public int centerZ = 0;

    public void readProperties(String properties) {
        String[] splitProperties;
        for (String property : splitProperties = properties.split(",")) {
            String[] splitProperty = property.split("=");
            String propertyName = splitProperty[0];
            String propertyValue = splitProperty[1];
            if (propertyName.equals("file")) {
                this.structureFile = new File("config/lucky/structures/" + propertyValue);
                this.structureFileName = propertyValue;
            }
            if (propertyName.equals("ID")) {
                this.structureID = propertyValue;
            }
            if (propertyName.equals("cenerX")) {
                this.centerX = Integer.valueOf(propertyValue);
            }
            if (propertyName.equals("cenerY")) {
                this.centerY = Integer.valueOf(propertyValue);
            }
            if (!propertyName.equals("cenerZ")) continue;
            this.centerZ = Integer.valueOf(propertyValue);
        }
        if (this.centerX == 0) {
            this.centerX = this.length / 2;
        }
        if (this.centerY == 0) {
            this.centerY = 1;
        }
        if (this.centerZ == 0) {
            this.centerZ = this.width / 2;
        }
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        this.length = nbtTagCompound.func_74765_d("Length");
        this.width = nbtTagCompound.func_74765_d("Width");
        this.height = nbtTagCompound.func_74765_d("Height");
        int size = this.length * this.width * this.height;
        if (size > 100000) {
            this.isStructureTooLarge = true;
            System.err.println("Lucky Block: Error loading structure. The structure '" + this.structureID + "' (" + size + " blocks) exceeds the 100000 block limit");
            return;
        }
        this.blocks = new int[this.height][this.length][this.width];
        this.blockData = new int[this.height][this.length][this.width];
        byte[] blockIdsByte = nbtTagCompound.func_74770_j("Blocks");
        byte[] blockDataByte = nbtTagCompound.func_74770_j("Data");
        int z = 1;
        int x = 1;
        int y = 1;
        for (int i = 0; i < blockIdsByte.length; ++i) {
            short blockId = (short)(blockIdsByte[i] & 0xFF);
            this.blocks[y - 1][x - 1][z - 1] = blockId;
            this.blockData[y - 1][x - 1][z - 1] = blockDataByte[i];
            if (++z > this.width) {
                z = 1;
                ++x;
            }
            if (x <= this.length) continue;
            x = 1;
            ++y;
        }
    }

    public void makeStructure(World world, int posX, int posY, int posZ) {
        if (this.isStructureTooLarge) {
            int size = this.length * this.width * this.height;
            System.err.println("Lucky Block: Error loading structure. The structure '" + this.structureID + "' (" + size + " blocks) exceeds the 100000 block limit");
            return;
        }
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.length; ++x) {
                for (int z = 0; z < this.width; ++z) {
                    int blockId = this.blocks[y][x][z];
                    int data = this.blockData[y][x][z];
                    int xOffset = this.centerX - (x + 1);
                    int yOffset = this.centerY - (y + 1);
                    int zOffset = this.centerZ - (z + 1);
                    int blockPosX = posX - xOffset;
                    int blockPosY = posY - yOffset;
                    int blockPosZ = posZ - zOffset;
                    Chunk chunk = world.func_72964_e(blockPosX, blockPosZ);
                    ExtendedBlockStorage storageArray = chunk.func_76587_i()[blockPosY >> 4];
                    if (storageArray == null) {
                        ExtendedBlockStorage[] storageArrays = chunk.func_76587_i();
                        storageArrays[blockPosY >> 4] = new ExtendedBlockStorage(storageArrays[(blockPosY >> 4) - 1].func_76662_d() + 16, !world.field_73011_w.func_177495_o());
                        storageArray = chunk.func_76587_i()[blockPosY >> 4];
                    }
                    if (storageArray.func_150819_a(blockPosX & 0xF, blockPosY & 0xF, blockPosZ & 0xF) == Block.func_149729_e((int)blockId)) continue;
                    storageArray.func_177484_a(blockPosX & 0xF, blockPosY & 0xF, blockPosZ & 0xF, Block.func_149729_e((int)blockId).func_176203_a(data));
                    chunk.func_177427_f(true);
                    world.func_175689_h(new BlockPos(blockPosX, blockPosY, blockPosZ));
                }
            }
        }
    }
}

