/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.util;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import mod.lucky.Lucky;
import mod.lucky.drop.LuckyDropBase;
import mod.lucky.gen.structure.Structure;
import mod.lucky.util.ExpressionParser;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class LuckyConfiguration {
    public static String getConfigVersion() {
        File file = new File("config/lucky/LuckyBlockProperties.txt");
        if (!file.exists()) {
            return "";
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream("config/lucky/LuckyBlockProperties.txt")));
            String version = br.readLine();
            br.close();
            if (version != null) {
                return version;
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public static void readConfig() {
        System.out.println("Lucky Block: Reading config");
        try {
            String currLine;
            BufferedReader propertiesReader = new BufferedReader(new InputStreamReader(new FileInputStream("config/lucky/LuckyBlockProperties.txt")));
            String section = "";
            boolean addSeparator = false;
            ArrayList<LuckyDropBase> dropsList = new ArrayList<LuckyDropBase>();
            ArrayList<Item> luckyCraftingItemsList = new ArrayList<Item>();
            ArrayList<Integer> luckyCraftingItemDamageList = new ArrayList<Integer>();
            ArrayList<Integer> luckyCraftingLevelsList = new ArrayList<Integer>();
            int dropNum = 0;
            String currDropLine = "";
            ExpressionParser expresisonParser = ExpressionParser.instance;
            while ((currLine = propertiesReader.readLine()) != null) {
                if (currLine.startsWith(">")) {
                    section = currLine;
                    continue;
                }
                if (currLine.startsWith("/") || currLine.equals("")) continue;
                try {
                    String value;
                    String name;
                    if (section.equals(">properties")) {
                        name = currLine.substring(0, currLine.indexOf(61));
                        value = currLine.substring(currLine.indexOf(61) + 1, currLine.length());
                        if (name.equals("recipe")) {
                            Lucky.instance.luckyCrafting.setLuckyBlockRecipe(value);
                        }
                        if (name.equals("spawnrate")) {
                            Lucky.instance.luckyGenerator.setSpawnrate(expresisonParser.getInteger(value));
                        }
                        if (name.equals("structureChance")) {
                            Lucky.instance.luckyGenerator.setStructureChance(expresisonParser.getInteger(value));
                        }
                        if (name.equals("doDropsOnCreativeMode")) {
                            Lucky.instance.doDropsOnCreativeMode = expresisonParser.getBoolean(currLine);
                        }
                    }
                    if (section.equals(">craftingitems")) {
                        name = currLine.substring(0, currLine.indexOf(61));
                        value = currLine.substring(currLine.indexOf(61) + 1, currLine.length());
                        String damageString = "";
                        if (name.indexOf(44) != -1) {
                            damageString = name.substring(name.indexOf(44) + 1, name.length());
                            name = name.substring(0, name.indexOf(44));
                        }
                        Item item = (Item)Item.field_150901_e.func_82594_a((Object)name);
                        int luck = 0;
                        int damage = -1;
                        try {
                            luck = expresisonParser.getInteger(value);
                            damage = expresisonParser.getInteger(damageString);
                        }
                        catch (ExpressionParser.ExpressionParserException e) {
                            // empty catch block
                        }
                        luckyCraftingItemsList.add(item);
                        luckyCraftingItemDamageList.add(damage);
                        luckyCraftingLevelsList.add(luck);
                    }
                    if (!section.equals(">drops")) continue;
                    boolean dropContinues = false;
                    if (currLine.endsWith(">")) {
                        currLine = currLine.substring(0, currLine.length() - 1);
                        dropContinues = true;
                    }
                    currDropLine = currDropLine + currLine;
                    if (dropContinues) continue;
                    dropsList.add(dropNum, new LuckyDropBase(currDropLine));
                    ++dropNum;
                    currDropLine = "";
                }
                catch (Exception e) {
                    System.err.println("Lucky Block: Error reading properties");
                    e.printStackTrace();
                }
            }
            propertiesReader.close();
            Lucky.instance.allDrops = dropsList.toArray(new LuckyDropBase[dropsList.size()]);
            Lucky.instance.luckyCrafting.luckyCraftingItems = luckyCraftingItemsList.toArray(new Item[luckyCraftingItemsList.size()]);
            Lucky.instance.luckyCrafting.luckyCraftingItemDamage = LuckyConfiguration.convertIntListToArray(luckyCraftingItemDamageList);
            Lucky.instance.luckyCrafting.luckyCraftingLevels = LuckyConfiguration.convertIntListToArray(luckyCraftingLevelsList);
            BufferedReader structuresReader = new BufferedReader(new InputStreamReader(new FileInputStream("config/lucky/structures/structures.txt")));
            ArrayList<Structure> structuresList = new ArrayList<Structure>();
            try {
                while ((currLine = structuresReader.readLine()) != null) {
                    if (currLine.equals("")) continue;
                    Structure structure = new Structure();
                    structure.readProperties(currLine);
                    DataInputStream datainputstream = new DataInputStream(new GZIPInputStream(new FileInputStream(structure.structureFile)));
                    NBTTagCompound nbtTagCompound = CompressedStreamTools.func_74794_a((DataInputStream)datainputstream);
                    structure.readFromNBT(nbtTagCompound);
                    datainputstream.close();
                    structuresList.add(structure);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            structuresReader.close();
            Lucky.instance.allStructures = structuresList.toArray(new Structure[structuresList.size()]);
        }
        catch (Exception e) {
            System.err.println("Lucky Block: Error reading structures");
            e.printStackTrace();
        }
    }

    public static void createNewConfigFile() {
        System.out.println("Lucky Block: Creating new config folder");
        LuckyConfiguration.copyFileFromJar("files/LuckyBlockProperties.txt", "config/lucky/LuckyBlockProperties.txt");
        LuckyConfiguration.copyFileFromJar("files/structures/structures.txt", "config/lucky/structures/structures.txt");
        try {
            String structureLine;
            BufferedReader structuresReader = new BufferedReader(new InputStreamReader(new FileInputStream("config/lucky/structures/structures.txt")));
            Structure structure = new Structure();
            while ((structureLine = structuresReader.readLine()) != null) {
                if (structureLine.equals("")) continue;
                structure.readProperties(structureLine);
                LuckyConfiguration.copyFileFromJar("files/structures/" + structure.structureFileName, "config/lucky/structures/" + structure.structureFileName);
            }
            structuresReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void copyFileFromJar(String source, String destination) {
        try {
            int readBytes;
            File destFile = new File(destination);
            if (destFile.exists()) {
                destFile.delete();
            }
            destFile.getParentFile().mkdirs();
            destFile.createNewFile();
            InputStream input = Lucky.class.getResourceAsStream(source);
            FileOutputStream output = new FileOutputStream(destFile);
            byte[] buffer = new byte[4096];
            while ((readBytes = input.read(buffer)) > 0) {
                ((OutputStream)output).write(buffer, 0, readBytes);
            }
            input.close();
            ((OutputStream)output).close();
        }
        catch (Exception e) {
            System.err.println("Error copying '" + source + "' to '" + destination + "':");
            e.printStackTrace();
        }
    }

    @Deprecated
    public static void fixIds(String drop) {
        int[] point = new int[10];
        String[] idWholeString = new String[10];
        String[] idWholeStringNew = new String[10];
        int amountOfIds = 0;
        for (int b = 0; b < 10; ++b) {
            point[b] = drop.indexOf("ID=", b == 0 ? 0 : point[b - 1] + 1);
            if (point[b] == -1) break;
            int endPoint = -1;
            int currEndPoint = drop.indexOf(44, point[b]);
            if (currEndPoint != -1 && (currEndPoint < endPoint || endPoint == -1)) {
                endPoint = currEndPoint;
            }
            if ((currEndPoint = drop.indexOf(59, point[b])) != -1 && (currEndPoint < endPoint || endPoint == -1)) {
                endPoint = currEndPoint;
            }
            if ((currEndPoint = drop.indexOf(41, point[b])) != -1 && (currEndPoint < endPoint || endPoint == -1)) {
                endPoint = currEndPoint;
            }
            if ((currEndPoint = drop.length()) != -1 && (currEndPoint < endPoint || endPoint == -1)) {
                endPoint = currEndPoint;
            }
            idWholeString[b] = drop.substring(point[b], endPoint);
            try {
                int idInt = Integer.valueOf(idWholeString[b].split("=")[1]);
                String idName = Item.field_150901_e.func_177774_c((Object)Item.func_150899_d((int)idInt)).toString().split(":")[1];
                idWholeStringNew[b] = "ID=" + idName;
            }
            catch (Exception e) {
                idWholeStringNew[b] = idWholeString[b];
            }
            ++amountOfIds;
        }
        String newDrop = drop;
        for (int b = 0; b < amountOfIds; ++b) {
            newDrop = newDrop.replaceAll(idWholeString[b], idWholeStringNew[b]);
        }
        newDrop = newDrop.replaceAll("name", "ID");
        System.out.println(newDrop);
    }

    public static int[] convertIntListToArray(ArrayList<Integer> integerList) {
        int[] integers = new int[integerList.size()];
        Iterator<Integer> iterator = integerList.iterator();
        for (int i = 0; i < integers.length; ++i) {
            integers[i] = iterator.next();
        }
        return integers;
    }
}

