/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.block;

import java.util.Random;
import mod.lucky.Lucky;
import mod.lucky.command.LuckyCommandLogic;
import mod.lucky.drop.LuckyDrop;
import mod.lucky.drop.LuckyDropBase;
import mod.lucky.item.ItemLuckyBlock;
import mod.lucky.tileentity.TileEntityLuckyBlock;
import mod.lucky.util.ChooseLuckyDrop;
import mod.lucky.util.LuckyFunction;
import mod.lucky.util.MakeLuckyDrops;
import mod.lucky.util.SpawnEntity;
import mod.lucky.util.SpawnOther;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerSelector;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class BlockLuckyBlock
extends BlockContainer {
    public SpawnOther spawnOther;
    public SpawnEntity spawnEntity;
    public MakeLuckyDrops makeLuckyDrops;
    private final Random random = new Random();

    public BlockLuckyBlock(Material material) {
        super(material);
        this.spawnEntity = new SpawnEntity();
        this.spawnOther = new SpawnOther();
        this.makeLuckyDrops = new MakeLuckyDrops();
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        world.func_175689_h(pos);
    }

    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block neighborBlock) {
        if (world.func_175640_z(pos)) {
            this.removeLuckyBlock(world, null, pos, true);
        }
    }

    public boolean removedByPlayer(World world, BlockPos harvestPos, EntityPlayer player, boolean willharvest) {
        return this.removeLuckyBlock(world, player, harvestPos, false);
    }

    public boolean removeLuckyBlock(World world, EntityPlayer player, BlockPos harvestPos, boolean removedByRedstone) {
        try {
            int luck = 0;
            String[] drops = null;
            LuckyDropBase[] savedDrops = null;
            TileEntityLuckyBlock tileEntityLuck = (TileEntityLuckyBlock)world.func_175625_s(harvestPos);
            if (tileEntityLuck != null) {
                luck = tileEntityLuck.getLuck();
                drops = tileEntityLuck.getDrops();
                if (drops != null && drops.length != 0) {
                    savedDrops = new LuckyDropBase[drops.length];
                    for (int a = 0; a < savedDrops.length; ++a) {
                        savedDrops[a] = new LuckyDropBase(drops[a]);
                    }
                }
                world.func_175713_t(harvestPos);
            }
            if (!world.func_175698_g(harvestPos)) {
                return false;
            }
            if (!world.field_72995_K) {
                if (removedByRedstone) {
                    LuckyCommandLogic luckyCommandLogic = new LuckyCommandLogic();
                    luckyCommandLogic.setWorld(world);
                    luckyCommandLogic.setPosition(harvestPos);
                    player = PlayerSelector.func_82386_a((ICommandSender)luckyCommandLogic, (String)"@p");
                }
                if (player.field_71075_bZ.field_75098_d && !Lucky.instance.doDropsOnCreativeMode && !removedByRedstone) {
                    return true;
                }
                if (EnchantmentHelper.func_77502_d((EntityLivingBase)player) && !removedByRedstone) {
                    ItemStack itemStack = new ItemStack(Lucky.lucky_block);
                    NBTTagCompound nbttag = new NBTTagCompound();
                    if (luck != 0) {
                        nbttag.func_74768_a("Luck", luck);
                    }
                    if (drops != null && drops.length != 0) {
                        nbttag.func_74782_a("Drops", (NBTBase)LuckyFunction.getNBTTagListFromArray(drops));
                    }
                    if (nbttag.func_74764_b("Luck") || nbttag.func_74764_b("Drops")) {
                        itemStack.func_77982_d(nbttag);
                    }
                    float f = 0.7f;
                    double x = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double y = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double z = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    EntityItem entityitem = new EntityItem(world, (double)harvestPos.func_177958_n() + x, (double)harvestPos.func_177956_o() + y, (double)harvestPos.func_177952_p() + z, itemStack);
                    entityitem.func_174869_p();
                    world.func_72838_d((Entity)entityitem);
                    return true;
                }
                LuckyDropBase[] baseDrops = savedDrops != null && savedDrops.length != 0 ? savedDrops : Lucky.instance.allDrops;
                LuckyDrop[] allDrops = this.makeLuckyDrops.getDrops(ChooseLuckyDrop.chooseDrop(baseDrops, luck), world, player, harvestPos);
                this.doDrop(allDrops, world, player, world.field_73012_v, harvestPos);
                return true;
            }
        }
        catch (Exception e) {
            System.err.println("The Lucky Block encountered and error while trying to perform a function. Error report below:");
            e.printStackTrace();
        }
        return true;
    }

    public void doDrop(LuckyDrop[] allDrops, World world, EntityPlayer player, Random random, BlockPos harvestPos) {
        try {
            this.spawnEntity.setRandom(random);
            int count = 0;
            while (allDrops[count] != null) {
                LuckyDrop currDrop = allDrops[count];
                if (currDrop.getType().equals("entity") || currDrop.getType().equals("falling_block")) {
                    this.spawnEntity.spawnEntity(world, player, currDrop);
                } else if (currDrop.getType().equals("effect")) {
                    PotionEffect potioneffect = new PotionEffect(Integer.valueOf(currDrop.getId()).intValue(), currDrop.getEffectDuration(), currDrop.getDamage());
                    player.func_70690_d(potioneffect);
                } else if (currDrop.getType().equals("difficulty")) {
                    EnumDifficulty enumdifficulty = !currDrop.getId().equalsIgnoreCase("peaceful") && !currDrop.getId().equalsIgnoreCase("p") ? (!currDrop.getId().equalsIgnoreCase("easy") && !currDrop.getId().equalsIgnoreCase("e") ? (!currDrop.getId().equalsIgnoreCase("normal") && !currDrop.getId().equalsIgnoreCase("n") ? (!currDrop.getId().equalsIgnoreCase("hard") && !currDrop.getId().equalsIgnoreCase("h") ? EnumDifficulty.func_151523_a((int)Integer.valueOf(currDrop.getId())) : EnumDifficulty.HARD) : EnumDifficulty.NORMAL) : EnumDifficulty.EASY) : EnumDifficulty.PEACEFUL;
                    MinecraftServer.func_71276_C().func_147139_a(enumdifficulty);
                } else if (currDrop.getType().equals("time")) {
                    for (EnumDifficulty worldServer : MinecraftServer.func_71276_C().field_71305_c) {
                        worldServer.func_72877_b(Long.valueOf(currDrop.getId()).longValue());
                    }
                } else if (currDrop.getType().equals("sound")) {
                    world.func_72956_a((Entity)player, currDrop.getId(), 3.0f, 1.0f);
                } else if (currDrop.getType().equals("command")) {
                    LuckyCommandLogic luckyCommandLogic = new LuckyCommandLogic();
                    luckyCommandLogic.setWorld(world);
                    luckyCommandLogic.setPosition(new BlockPos(currDrop.getPosX(), currDrop.getPosY(), currDrop.getPosZ()));
                    luckyCommandLogic.setCommand(currDrop.getId());
                    luckyCommandLogic.setName(currDrop.getCommandSender());
                    luckyCommandLogic.setDoOutput(currDrop.getDisplayCommandOutput());
                    luckyCommandLogic.executeCommand();
                    System.out.println(luckyCommandLogic.getCommand());
                } else if (currDrop.getType().equals("message")) {
                    MinecraftServer.func_71276_C().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText(currDrop.getId()));
                } else if (currDrop.getType().equals("particle") || currDrop.getType().equals("block") || currDrop.getType().equals("structure")) {
                    this.spawnOther.spawnOther(world, player, random, currDrop);
                } else if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
                    ItemStack itemStack;
                    float f = 0.7f;
                    double x = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double y = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double z = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    try {
                        int id = Integer.valueOf(currDrop.getId());
                        itemStack = new ItemStack((Item)Item.field_150901_e.func_148754_a(id), 1, currDrop.getDamage());
                    }
                    catch (NumberFormatException e) {
                        itemStack = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)currDrop.getId()), 1, currDrop.getDamage());
                    }
                    itemStack.func_77982_d(currDrop.getNBTTag());
                    EntityItem entityitem = new EntityItem(world, (double)currDrop.getPosX() + x, (double)currDrop.getPosY() + y, (double)currDrop.getPosZ() + z, itemStack);
                    entityitem.func_174869_p();
                    world.func_72838_d((Entity)entityitem);
                }
                ++count;
            }
        }
        catch (Exception e) {
            System.err.println("The Lucky Block encountered and error while trying to perform a function. Error report below:");
            e.printStackTrace();
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    private boolean canStayOnBlock(Block soil) {
        return soil == Blocks.field_150349_c || soil == Blocks.field_150346_d || soil == Blocks.field_150354_m || soil == Blocks.field_150348_b || soil == Blocks.field_150351_n || soil == Blocks.field_150424_aL || soil == Blocks.field_150425_aM || soil == Blocks.field_150385_bj || soil == Blocks.field_150385_bj || soil == Blocks.field_150377_bs;
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        Block currBlock = world.func_180495_p(pos).func_177230_c();
        Block soil = world.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p())).func_177230_c();
        return (world.getBlockLightOpacity(pos) >= 8 || world.func_175710_j(pos)) && soil != null && this.canStayOnBlock(soil);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityLuckyBlock();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack itemStack) {
        TileEntityLuckyBlock tileEntityLuck = (TileEntityLuckyBlock)world.func_175625_s(pos);
        if (tileEntityLuck == null) {
            return;
        }
        int luck = ItemLuckyBlock.getLuck(itemStack);
        String[] drops = ItemLuckyBlock.getDrops(itemStack);
        tileEntityLuck.setLuck(luck);
        if (drops != null && drops.length != 0) {
            tileEntityLuck.setDrops(drops);
        }
        tileEntityLuck.func_70296_d();
        world.func_175689_h(pos);
        if (world.func_175640_z(pos) && !world.field_72995_K) {
            this.removeLuckyBlock(world, null, pos, true);
        }
    }

    public int func_149645_b() {
        return 3;
    }
}

