/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.drop;

import java.util.ArrayList;
import java.util.Random;
import mod.lucky.util.ExpressionParser;

public class LuckyDropBase {
    private String rawDrop;
    private int luck = 2;
    private float chance = 1.0f;
    private final Random random;

    public LuckyDropBase(String rawDrop) {
        if (rawDrop.startsWith("(") && rawDrop.endsWith(")") || rawDrop.startsWith("[") && rawDrop.endsWith("]") || rawDrop.startsWith("{") && rawDrop.endsWith("}")) {
            rawDrop = rawDrop.substring(1, rawDrop.length() - 1);
        }
        this.rawDrop = rawDrop;
        this.random = new Random();
        try {
            this.getDropProperties();
        }
        catch (ExpressionParser.ExpressionParserException e) {
            System.out.println("The Lucky Block encountered and error while loading properties for drop: " + rawDrop);
            e.printStackTrace();
        }
    }

    public LuckyDropBase() {
        this.random = new Random();
    }

    /*
     * WARNING - void declaration
     */
    public void getDropProperties() throws ExpressionParser.ExpressionParserException {
        ExpressionParser expressionParser = ExpressionParser.instance;
        ArrayList<Integer> points = new ArrayList<Integer>();
        int count = 0;
        while (true) {
            void var6_6;
            void var7_7;
            int propertyStringLength;
            boolean propertyType;
            int luckPoint;
            int chancePoint;
            if ((chancePoint = this.rawDrop.indexOf("@chance=")) < (luckPoint = this.rawDrop.indexOf("@luck=")) && chancePoint != -1 || luckPoint == -1 && chancePoint > -1) {
                propertyType = false;
                propertyStringLength = "@chance=".length();
                points.add(count, chancePoint);
            } else {
                if ((luckPoint >= chancePoint || luckPoint == -1) && (chancePoint != -1 || luckPoint <= -1)) break;
                propertyType = true;
                propertyStringLength = "@luck=".length();
                points.add(count, luckPoint);
            }
            char[] invalidChars = new char[]{'+', '*', '(', ')', ',', ';', '/', '@'};
            int currEndPoint = expressionParser.getEndPoint(this.rawDrop, (Integer)points.get(count) + var7_7, invalidChars);
            String currValue = this.rawDrop.substring((Integer)points.get(count) + var7_7, currEndPoint);
            if (currValue.startsWith("(") && currValue.endsWith(")")) {
                currValue = currValue.substring(1, currValue.length() - 1);
            }
            if (var6_6 == false) {
                this.chance = expressionParser.getFloat(currValue);
            }
            if (var6_6 == true) {
                this.luck = expressionParser.getInteger(currValue);
            }
            String linePart1 = this.rawDrop.substring(0, (Integer)points.get(count));
            String linePart2 = this.rawDrop.substring(currEndPoint, this.rawDrop.length());
            this.rawDrop = linePart1 + linePart2;
            ++count;
        }
    }

    public LuckyDropBase copy() {
        LuckyDropBase luckyDropBase = new LuckyDropBase("");
        luckyDropBase.rawDrop = this.rawDrop;
        luckyDropBase.luck = this.luck;
        luckyDropBase.chance = this.chance;
        return luckyDropBase;
    }

    public String getDropValue() {
        return this.rawDrop;
    }

    public void setDropValue(String dropValue) {
        this.rawDrop = dropValue;
    }

    public int getLuck() {
        return this.luck;
    }

    public void setLuck(int luck) {
        this.luck = luck;
    }

    public float getChance() {
        return this.chance;
    }

    public void setChance(float chance) {
        this.chance = chance;
    }

    public String toString() {
        return this.rawDrop;
    }
}

