/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.util;

import java.util.ArrayList;
import java.util.Random;
import mod.lucky.drop.LuckyDropBase;

public class ChooseLuckyDrop {
    public static LuckyDropBase chooseDrop(LuckyDropBase[] allDrops, int luck) {
        LuckyDropBase[] drops = new LuckyDropBase[allDrops.length];
        int lowestLuck = 0;
        int heighestLuck = 0;
        for (int a = 0; a < drops.length; ++a) {
            drops[a] = allDrops[a].copy();
            if (drops[a].getLuck() < lowestLuck) {
                lowestLuck = drops[a].getLuck();
            }
            if (drops[a].getLuck() <= heighestLuck) continue;
            heighestLuck = drops[a].getLuck();
        }
        heighestLuck += lowestLuck * -1 + 1;
        float levelIncrease = 1.0f / (1.0f - (float)(luck < 0 ? luck * -1 : luck) * 0.77f / 100.0f);
        float weightTotal = 0.0f;
        ArrayList<Float> weightPoints = new ArrayList<Float>();
        weightPoints.add(Float.valueOf(0.0f));
        for (LuckyDropBase drop : drops) {
            int dropLuck = drop.getLuck() + lowestLuck * -1 + 1;
            float newLuck = 0.0f;
            newLuck = luck >= 0 ? (float)Math.pow(levelIncrease, dropLuck) : (float)Math.pow(levelIncrease, heighestLuck + 1 - dropLuck);
            float newChance = drop.getChance() * newLuck * 100.0f;
            drop.setChance(newChance);
            weightPoints.add(Float.valueOf(weightTotal += newChance));
        }
        Random random = new Random();
        float randomIndex = random.nextFloat() * weightTotal;
        LuckyDropBase chosenDrop = ChooseLuckyDrop.getDropByWeight(drops, weightPoints, randomIndex);
        return chosenDrop;
    }

    private static LuckyDropBase getDropByWeight(LuckyDropBase[] drops, ArrayList<Float> weightPoints, float randomIndex) {
        for (int a = 0; a < drops.length; ++a) {
            if (!(randomIndex >= weightPoints.get(a).floatValue()) || !(randomIndex < weightPoints.get(a + 1).floatValue())) continue;
            return drops[a];
        }
        return null;
    }
}

