/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.util;

import java.util.ArrayList;
import java.util.Random;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import mod.lucky.util.LuckyFunction;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ExpressionParser {
    public static final ExpressionParser instance = new ExpressionParser();
    private final ScriptEngine scritptEngine;
    private final Random random;
    public EntityPlayer player;
    public World world;
    public int harvestX;
    public int harvestY;
    public int harvestZ;

    public ExpressionParser() {
        ScriptEngineManager mgr = new ScriptEngineManager(null);
        this.scritptEngine = mgr.getEngineByName("JavaScript");
        this.random = new Random();
    }

    private String getFormattedString(String value) throws ExpressionParserException {
        if (value.contains("#rand")) {
            value = this.replaceRandoms(value);
        }
        value = value.replaceAll("#randomPotionDamage", String.valueOf(LuckyFunction.getRandomPotionDamage()));
        value = value.replaceAll("#randomPotionEffect", String.valueOf(LuckyFunction.getRandomPotionEffect()));
        value = value.replaceAll("#randomSpawnEggDamage", String.valueOf(LuckyFunction.getRandomMobEgg()));
        value = value.replaceAll("#bPosX", String.valueOf(this.harvestX));
        value = value.replaceAll("#bPosY", String.valueOf(this.harvestY));
        value = value.replaceAll("#bPosZ", String.valueOf(this.harvestZ));
        if (this.player != null) {
            value = value.replaceAll("#pPosX", String.valueOf(MathHelper.func_76128_c((double)this.player.field_70165_t)));
            value = value.replaceAll("#pPosY", String.valueOf(MathHelper.func_76128_c((double)this.player.field_70163_u)));
            value = value.replaceAll("#pPosZ", String.valueOf(MathHelper.func_76128_c((double)this.player.field_70161_v)));
            value = value.replaceAll("#playerName", this.player.func_145748_c_().func_150260_c());
        }
        value = value.replaceAll("'#'", "'\u00a7'");
        value = value.replaceAll("#", "\u00a7");
        value = value.replaceAll("'\u00a7'", "#");
        return value;
    }

    private String fixBackslash(String value) {
        value = value.replaceAll("\\\\t", "\t");
        value = value.replaceAll("\\\\b", "\b");
        value = value.replaceAll("\\\\n", "\n");
        value = value.replaceAll("\\\\r", "\r");
        value = value.replaceAll("\\\\f", "\f");
        return value;
    }

    public String replaceRandoms(String value) throws ExpressionParserException {
        String[] randStrings = new String[]{"#rand(", "#randPosNeg(", "#randList("};
        ArrayList<Integer> points = new ArrayList<Integer>();
        int count = 0;
        while (true) {
            int minPoint = -1;
            int minIndex = -1;
            for (int i = 0; i < randStrings.length; ++i) {
                int point = value.indexOf(randStrings[i], count == 0 ? 0 : (Integer)points.get(count - 1) + 1);
                if (point == -1 || minPoint != -1 && point >= minPoint) continue;
                minPoint = point;
                minIndex = i;
            }
            if (minPoint == -1) break;
            int randomType = minIndex;
            int randomStringLength = randStrings[minIndex].length();
            points.add(count, minPoint);
            String curRandom = "";
            int curEndPoint = -1;
            char[] lineChar = value.toCharArray();
            int bracketTier = 0;
            boolean inQuotesBefore = false;
            boolean inQuotesNow = false;
            char[] newLine = new char[lineChar.length];
            int writeIndex = 0;
            for (int i = 0; i < lineChar.length; ++i) {
                boolean charCanceled = i > 0 && lineChar[i - 1] == '\\';
                newLine[writeIndex] = lineChar[i];
                if (i >= (Integer)points.get(count) + randomStringLength - 1) {
                    if (!charCanceled) {
                        if (lineChar[i] == '\"') {
                            boolean bl = inQuotesNow = !inQuotesNow;
                        }
                        if (!(lineChar[i] != '(' && lineChar[i] != '[' && lineChar[i] != '{' || inQuotesNow)) {
                            ++bracketTier;
                        }
                        if (!(lineChar[i] != ')' && lineChar[i] != ']' && lineChar[i] != '}' || inQuotesNow)) {
                            --bracketTier;
                        }
                        if (bracketTier == 0) {
                            char[] newLinefinal = new char[writeIndex];
                            for (int j = 0; j < newLinefinal.length; ++j) {
                                newLinefinal[j] = newLine[j];
                            }
                            curRandom = new String(newLinefinal);
                            curEndPoint = i;
                            break;
                        }
                    }
                    if (lineChar[i] == '\"' && charCanceled && inQuotesBefore) {
                        boolean charDoubleCanceled;
                        newLine[--writeIndex] = 34;
                        boolean bl = charDoubleCanceled = i > 1 && lineChar[i - 2] == '\\';
                        if (!charDoubleCanceled) {
                            inQuotesNow = !inQuotesNow;
                        }
                    }
                } else if (lineChar[i] == '\"' && !charCanceled) {
                    inQuotesBefore = !inQuotesBefore;
                }
                ++writeIndex;
            }
            curRandom = curRandom.substring((Integer)points.get(count) + randomStringLength, curRandom.length());
            String[] splitValue = LuckyFunction.splitBracketString(curRandom, ',');
            String result = "";
            if (randomType == 0 || randomType == 1) {
                boolean isFloat = this.isFloat(splitValue[0]) || this.isFloat(splitValue[1]);
                splitValue[0] = this.removeSuffix(splitValue[0]);
                splitValue[1] = this.removeSuffix(splitValue[1]);
                if (isFloat) {
                    float min = this.getFloat(splitValue[0]);
                    float max = this.getFloat(splitValue[1]);
                    float num = MathHelper.func_151240_a((Random)this.random, (float)min, (float)max);
                    if (randomType == 1 && this.random.nextInt(2) == 0) {
                        num *= -1.0f;
                    }
                    result = String.valueOf(num);
                } else {
                    int min = this.getInteger(splitValue[0]);
                    int max = this.getInteger(splitValue[1]);
                    int num = this.random.nextInt(max - min + 1) + min;
                    if (randomType == 1 && this.random.nextInt(2) == 0) {
                        num *= -1;
                    }
                    result = String.valueOf(num);
                }
            } else if (randomType == 2) {
                int index = this.random.nextInt(splitValue.length);
                result = this.getString(splitValue[index]);
            }
            String valuePart1 = value.substring(0, (Integer)points.get(count));
            String valuePart2 = value.substring(curEndPoint + 1, value.length());
            value = valuePart1 + result + valuePart2;
            ++count;
        }
        return value;
    }

    public int getEndPoint(String value, int startPoint, char ... invalidChars) {
        char[] chars = value.toCharArray();
        int endPoint = chars.length;
        for (int i = startPoint; i < chars.length; ++i) {
            boolean shouldBreak = false;
            for (char invalidChar : invalidChars) {
                if (chars[i] != invalidChar) continue;
                endPoint = i;
                shouldBreak = true;
                break;
            }
            if (shouldBreak) break;
        }
        return endPoint;
    }

    public boolean isFloat(String s) {
        boolean endsWithDecimalPoint = false;
        for (int i = s.length() - 1; i >= 0; --i) {
            if (Character.isDigit(s.charAt(i))) continue;
            if (s.charAt(i) != '.') break;
            endsWithDecimalPoint = true;
            break;
        }
        return s.endsWith("f") || s.endsWith("F") || s.endsWith("d") || s.endsWith("D") || endsWithDecimalPoint;
    }

    public String removeSuffix(String s) {
        if (s.endsWith("f") || s.endsWith("F") || s.endsWith("d") || s.endsWith("D") || s.endsWith("s") || s.endsWith("S") || s.endsWith("b") || s.endsWith("B")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    public Object getObject(String value) throws ExpressionParserException {
        value = this.getFormattedString(value);
        try {
            Object obj = this.scritptEngine.eval(value);
            return obj;
        }
        catch (Exception e) {
            throw new ExpressionParserException(value, e);
        }
    }

    public String getString(String value) throws ExpressionParserException {
        value = value.trim();
        value = this.getFormattedString(value);
        try {
            Object obj = this.scritptEngine.eval(value);
            if (obj instanceof String) {
                String s = (String)obj;
                return this.fixBackslash(s);
            }
            if (obj instanceof Double && String.valueOf(obj).endsWith(".0")) {
                String s = String.valueOf(obj);
                int i = this.getInteger(s);
                return this.fixBackslash(String.valueOf(i));
            }
            return this.fixBackslash(String.valueOf(obj));
        }
        catch (Exception e) {
            return value;
        }
    }

    public boolean getBoolean(String value) throws ExpressionParserException {
        value = this.getFormattedString(value);
        try {
            Object obj = this.scritptEngine.eval(value);
            if (obj instanceof Boolean) {
                boolean b = (Boolean)obj;
                return b;
            }
            throw new ExpressionParserException(value, null);
        }
        catch (Exception e) {
            throw new ExpressionParserException(value, e);
        }
    }

    public int getInteger(String value) throws ExpressionParserException {
        value = this.getFormattedString(value);
        try {
            Object obj = this.scritptEngine.eval(value);
            if (obj instanceof Integer) {
                int i = (Integer)obj;
                return i;
            }
            if (obj instanceof Double) {
                double d = (Double)obj;
                return (int)d;
            }
            if (obj instanceof Float) {
                float f = ((Float)obj).floatValue();
                return (int)f;
            }
            throw new ExpressionParserException(value, null);
        }
        catch (Exception e) {
            throw new ExpressionParserException(value, e);
        }
    }

    public double getDouble(String value) throws ExpressionParserException {
        value = this.getFormattedString(value);
        try {
            Object obj = this.scritptEngine.eval(value);
            if (obj instanceof Double) {
                double d = (Double)obj;
                return d;
            }
            if (obj instanceof Integer) {
                int i = (Integer)obj;
                return i;
            }
            if (obj instanceof Float) {
                float f = ((Float)obj).floatValue();
                return f;
            }
            throw new ExpressionParserException(value, null);
        }
        catch (Exception e) {
            throw new ExpressionParserException(value, e);
        }
    }

    public float getFloat(String value) throws ExpressionParserException {
        value = this.getFormattedString(value);
        try {
            Object obj = this.scritptEngine.eval(value);
            if (obj instanceof Float) {
                float f = ((Float)obj).floatValue();
                return f;
            }
            if (obj instanceof Integer) {
                int i = (Integer)obj;
                return i;
            }
            if (obj instanceof Double) {
                double d = (Double)obj;
                return (float)d;
            }
            throw new ExpressionParserException(value, null);
        }
        catch (Exception e) {
            throw new ExpressionParserException(value, e);
        }
    }

    public short getShort(String value) throws ExpressionParserException {
        try {
            return (short)this.getInteger(value);
        }
        catch (Exception e) {
            throw new ExpressionParserException(value, e);
        }
    }

    public byte getByte(String value) throws ExpressionParserException {
        try {
            return (byte)this.getInteger(value);
        }
        catch (Exception e) {
            throw new ExpressionParserException(value, e);
        }
    }

    public class ExpressionParserException
    extends Exception {
        public ExpressionParserException(String value, Exception exception) {
            super("Invalid input string: " + value + (exception instanceof ScriptException ? "\nScript Error: " + exception.getMessage() : ""));
        }

        public ExpressionParserException() {
        }
    }
}

