/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.maze;

import ivorius.ivtoolkit.math.IvVecMathHelper;
import ivorius.ivtoolkit.maze.MazePath;
import ivorius.ivtoolkit.maze.MazeRoom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.WeightedRandom;

public class MazeComponent
extends WeightedRandom.Item {
    private String identifier;
    private List<MazeRoom> rooms = new ArrayList<MazeRoom>();
    private List<MazePath> exitPaths = new ArrayList<MazePath>();

    public MazeComponent(int par1, String identifier, List<MazeRoom> rooms, List<MazePath> exitPaths) {
        super(par1);
        this.identifier = identifier;
        this.rooms.addAll(rooms);
        this.exitPaths.addAll(exitPaths);
    }

    public MazeComponent(NBTTagCompound compound) {
        super(compound.func_74762_e("weight"));
        this.identifier = compound.func_74779_i("identifier");
        NBTTagList roomsList = compound.func_150295_c("rooms", 10);
        this.rooms.clear();
        for (int i = 0; i < roomsList.func_74745_c(); ++i) {
            this.rooms.add(new MazeRoom(roomsList.func_150305_b(i)));
        }
        NBTTagList exitsList = compound.func_150295_c("exits", 10);
        this.exitPaths.clear();
        for (int i = 0; i < exitsList.func_74745_c(); ++i) {
            this.exitPaths.add(new MazePath(exitsList.func_150305_b(i)));
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public List<MazeRoom> getRooms() {
        return Collections.unmodifiableList(this.rooms);
    }

    public void setRooms(List<MazeRoom> rooms) {
        this.rooms.clear();
        this.rooms.addAll(rooms);
    }

    public List<MazePath> getExitPaths() {
        return Collections.unmodifiableList(this.exitPaths);
    }

    public void setExitPaths(List<MazePath> exitPaths) {
        this.exitPaths.clear();
        this.exitPaths.addAll(exitPaths);
    }

    public int[] getSize() {
        int[] lowest = (int[])this.rooms.get((int)0).coordinates.clone();
        int[] highest = (int[])this.rooms.get((int)0).coordinates.clone();
        for (MazeRoom room : this.rooms) {
            for (int i = 0; i < room.coordinates.length; ++i) {
                if (room.coordinates[i] < lowest[i]) {
                    lowest[i] = room.coordinates[i];
                    continue;
                }
                if (room.coordinates[i] <= highest[i]) continue;
                highest[i] = room.coordinates[i];
            }
        }
        int[] size = IvVecMathHelper.sub(highest, new int[][]{lowest});
        int i = 0;
        while (i < size.length) {
            int n = i++;
            size[n] = size[n] + 1;
        }
        return size;
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74778_a("identifier", this.identifier);
        compound.func_74768_a("weight", this.field_76292_a);
        NBTTagList roomsList = new NBTTagList();
        for (MazeRoom room : this.rooms) {
            roomsList.func_74742_a((NBTBase)room.writeToNBT());
        }
        compound.func_74782_a("rooms", (NBTBase)roomsList);
        NBTTagList exitsList = new NBTTagList();
        for (MazePath exit : this.exitPaths) {
            exitsList.func_74742_a((NBTBase)exit.writeToNBT());
        }
        compound.func_74782_a("exits", (NBTBase)exitsList);
    }
}

