/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.maze;

import ivorius.ivtoolkit.math.IvVecMathHelper;
import ivorius.ivtoolkit.maze.MazeCoordinate;
import java.util.Arrays;
import net.minecraft.nbt.NBTTagCompound;

public class MazeRoom
implements MazeCoordinate,
Cloneable {
    public final int[] coordinates;

    public MazeRoom(int ... coordinates) {
        this.coordinates = coordinates;
    }

    public MazeRoom(NBTTagCompound compound) {
        this.coordinates = compound.func_74759_k("coordinates");
    }

    public int getDimensions() {
        return this.coordinates.length;
    }

    public int[] getCoordinates() {
        return this.coordinates;
    }

    public MazeRoom add(MazeRoom room) {
        return new MazeRoom(IvVecMathHelper.add(this.coordinates, room.coordinates));
    }

    public MazeRoom sub(MazeRoom room) {
        return new MazeRoom(IvVecMathHelper.sub(this.coordinates, new int[][]{room.coordinates}));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MazeRoom mazeRoom = (MazeRoom)o;
        return Arrays.equals(this.coordinates, mazeRoom.coordinates);
    }

    public int hashCode() {
        return Arrays.hashCode(this.coordinates);
    }

    public String toString() {
        return Arrays.toString(this.coordinates);
    }

    public MazeRoom clone() {
        return new MazeRoom((int[])this.coordinates.clone());
    }

    @Override
    public int[] getMazeCoordinates() {
        int[] coords = new int[this.coordinates.length];
        for (int i = 0; i < coords.length; ++i) {
            coords[i] = this.coordinates[i] * 2 + 1;
        }
        return coords;
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74783_a("coordinates", this.coordinates);
        return compound;
    }
}

