/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.raytracing;

import ivorius.ivtoolkit.raytracing.IvRaytraceableObject;
import ivorius.ivtoolkit.raytracing.IvRaytracedIntersection;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.opengl.GL11;

public class IvRaytracer {
    public static List<IvRaytracedIntersection> getIntersections(List<IvRaytraceableObject> objects, double x, double y, double z, double xDir, double yDir, double zDir) {
        ArrayList<IvRaytracedIntersection> hitPoints = new ArrayList<IvRaytracedIntersection>();
        for (IvRaytraceableObject object : objects) {
            object.addIntersectionsForLineToList(hitPoints, x, y, z, xDir, yDir, zDir);
        }
        return hitPoints;
    }

    public static IvRaytracedIntersection findFirstIntersection(List<IvRaytracedIntersection> intersections, double x, double y, double z, double xDir, double yDir, double zDir) {
        IvRaytracedIntersection firstPoint = null;
        double firstDistanceSQ = -1.0;
        for (IvRaytracedIntersection point : intersections) {
            double pointDistSQ = (x - point.getX()) * (x - point.getX()) + (y - point.getY()) * (y - point.getY()) + (z - point.getZ()) * (z - point.getZ());
            boolean forwards = point.getX() - x > 0.0 == xDir > 0.0 && point.getY() - y > 0.0 == yDir > 0.0 && point.getZ() - z > 0.0 == zDir > 0.0;
            if (!forwards || !(firstDistanceSQ < 0.0) && !(pointDistSQ < firstDistanceSQ)) continue;
            firstPoint = point;
            firstDistanceSQ = pointDistSQ;
        }
        return firstPoint;
    }

    public static IvRaytracedIntersection getFirstIntersection(List<IvRaytraceableObject> objects, double x, double y, double z, double xDir, double yDir, double zDir) {
        ArrayList<IvRaytracedIntersection> intersections = new ArrayList<IvRaytracedIntersection>();
        for (IvRaytraceableObject object : objects) {
            object.addIntersectionsForLineToList(intersections, x, y, z, xDir, yDir, zDir);
        }
        return IvRaytracer.findFirstIntersection(intersections, x, y, z, xDir, yDir, zDir);
    }

    public static void drawStandardOutlines(List<IvRaytraceableObject> objects) {
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glLineWidth((float)2.0f);
        GL11.glDisable((int)3553);
        GL11.glDepthMask((boolean)false);
        Random r = new Random(0L);
        for (IvRaytraceableObject object : objects) {
            int color = r.nextInt();
            GL11.glColor4f((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color >> 0 & 0xFF) / 255.0f), (float)0.8f);
            object.drawOutlines();
        }
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }
}

