/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.tools;

import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.ivtoolkit.tools.MCRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class IvWorldData {
    public static final String ID_FIX_TAG_KEY = "SG_ID_FIX_TAG";
    public IvBlockCollection blockCollection;
    public List<TileEntity> tileEntities;
    public List<Entity> entities;

    public IvWorldData(IvBlockCollection blockCollection, List<TileEntity> tileEntities, List<Entity> entities) {
        this.blockCollection = blockCollection;
        this.tileEntities = tileEntities;
        this.entities = entities;
    }

    public IvWorldData(World world, BlockArea blockArea, boolean captureEntities) {
        int[] size = blockArea.areaSize();
        this.blockCollection = new IvBlockCollection(size[0], size[1], size[2]);
        this.tileEntities = new ArrayList<TileEntity>();
        for (BlockCoord worldCoord : blockArea) {
            BlockCoord dataCoord = worldCoord.subtract(blockArea.getLowerCorner());
            this.blockCollection.setBlock(dataCoord, world.func_147439_a(worldCoord.x, worldCoord.y, worldCoord.z));
            this.blockCollection.setMetadata(dataCoord, (byte)world.func_72805_g(worldCoord.x, worldCoord.y, worldCoord.z));
            TileEntity tileEntity = world.func_147438_o(worldCoord.x, worldCoord.y, worldCoord.z);
            if (tileEntity == null) continue;
            this.tileEntities.add(tileEntity);
        }
        if (captureEntities) {
            this.entities = world.func_72839_b(null, blockArea.asAxisAlignedBB());
            Iterator<Entity> entityIterator = this.entities.iterator();
            while (entityIterator.hasNext()) {
                Entity entity = entityIterator.next();
                if (!(entity instanceof EntityPlayer)) continue;
                entityIterator.remove();
            }
        } else {
            this.entities = Collections.emptyList();
        }
    }

    public IvWorldData(NBTTagCompound compound, World world, MCRegistry registry) {
        this.blockCollection = new IvBlockCollection(compound.func_74775_l("blockCollection"), registry);
        NBTTagList teList = compound.func_150295_c("tileEntities", 10);
        this.tileEntities = new ArrayList<TileEntity>(teList.func_74745_c());
        for (int i = 0; i < teList.func_74745_c(); ++i) {
            NBTTagCompound teCompound = teList.func_150305_b(i);
            IvWorldData.recursivelyApplyIDFixTags(teCompound, registry);
            TileEntity tileEntity = TileEntity.func_145827_c((NBTTagCompound)teCompound);
            this.tileEntities.add(tileEntity);
        }
        if (world != null) {
            NBTTagList entityList = compound.func_150295_c("entities", 10);
            this.entities = new ArrayList<Entity>(entityList.func_74745_c());
            for (int i = 0; i < entityList.func_74745_c(); ++i) {
                NBTTagCompound entityCompound = entityList.func_150305_b(i);
                IvWorldData.recursivelyApplyIDFixTags(entityCompound, registry);
                Entity entity = EntityList.func_75615_a((NBTTagCompound)entityCompound, (World)world);
                this.entities.add(entity);
            }
        }
    }

    public NBTTagCompound createTagCompound(BlockCoord referenceCoord) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("blockCollection", (NBTBase)this.blockCollection.createTagCompound());
        NBTTagList teList = new NBTTagList();
        for (TileEntity tileEntity : this.tileEntities) {
            NBTTagCompound teCompound = new NBTTagCompound();
            tileEntity.field_145851_c -= referenceCoord.x;
            tileEntity.field_145848_d -= referenceCoord.y;
            tileEntity.field_145849_e -= referenceCoord.z;
            tileEntity.func_145841_b(teCompound);
            tileEntity.field_145851_c += referenceCoord.x;
            tileEntity.field_145848_d += referenceCoord.y;
            tileEntity.field_145849_e += referenceCoord.z;
            IvWorldData.recursivelyInjectIDFixTags(teCompound);
            teList.func_74742_a((NBTBase)teCompound);
        }
        compound.func_74782_a("tileEntities", (NBTBase)teList);
        NBTTagList entityList = new NBTTagList();
        for (Entity entity : this.entities) {
            NBTTagCompound entityCompound = new NBTTagCompound();
            entity.field_70165_t -= (double)referenceCoord.x;
            entity.field_70163_u -= (double)referenceCoord.y;
            entity.field_70161_v -= (double)referenceCoord.z;
            entity.func_70039_c(entityCompound);
            entity.field_70165_t += (double)referenceCoord.x;
            entity.field_70163_u += (double)referenceCoord.y;
            entity.field_70161_v += (double)referenceCoord.z;
            IvWorldData.recursivelyInjectIDFixTags(entityCompound);
            entityList.func_74742_a((NBTBase)entityCompound);
        }
        compound.func_74782_a("entities", (NBTBase)entityList);
        return compound;
    }

    public static void recursivelyInjectIDFixTags(NBTTagCompound compound) {
        IvWorldData.injectIDFixTags(compound);
        for (Object key : compound.func_150296_c()) {
            String keyString = (String)key;
            NBTBase innerCompound = compound.func_74781_a(keyString);
            if (innerCompound instanceof NBTTagCompound) {
                IvWorldData.recursivelyInjectIDFixTags((NBTTagCompound)innerCompound);
                continue;
            }
            if (!(innerCompound instanceof NBTTagList)) continue;
            IvWorldData.recursivelyInjectIDFixTags((NBTTagList)innerCompound);
        }
    }

    public static void recursivelyInjectIDFixTags(NBTTagList list) {
        int tagType = list.func_150303_d();
        switch (tagType) {
            case 10: {
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    IvWorldData.recursivelyInjectIDFixTags(list.func_150305_b(i));
                }
                break;
            }
        }
    }

    public static void injectIDFixTags(NBTTagCompound compound) {
        NBTTagList list = null;
        if (compound.func_74764_b("id") && compound.func_74764_b("Count") && compound.func_74764_b("Damage")) {
            list = new NBTTagList();
            IvWorldData.addItemTag(compound.func_74762_e("id"), list, "id");
        }
        if (list != null) {
            compound.func_74782_a(ID_FIX_TAG_KEY, list);
        }
    }

    public static void addItemTag(int itemID, NBTTagList tagList, String tagDest) {
        Item item = Item.func_150899_d((int)itemID);
        if (item != null) {
            String stringID = Item.field_150901_e.func_148750_c((Object)item);
            NBTTagCompound idCompound = new NBTTagCompound();
            idCompound.func_74778_a("type", "item");
            idCompound.func_74778_a("tagDest", tagDest);
            idCompound.func_74778_a("itemID", stringID);
            tagList.func_74742_a((NBTBase)idCompound);
        } else {
            System.out.println("Failed to apply item tag for structure with ID '" + itemID + "'");
        }
    }

    public static void recursivelyApplyIDFixTags(NBTTagCompound compound, MCRegistry registry) {
        IvWorldData.applyIDFixTags(compound, registry);
        compound.func_82580_o(ID_FIX_TAG_KEY);
        for (Object key : compound.func_150296_c()) {
            String keyString = (String)key;
            NBTBase innerCompound = compound.func_74781_a(keyString);
            if (innerCompound instanceof NBTTagCompound) {
                IvWorldData.recursivelyApplyIDFixTags((NBTTagCompound)innerCompound, registry);
                continue;
            }
            if (!(innerCompound instanceof NBTTagList)) continue;
            IvWorldData.recursivelyApplyIDFixTags((NBTTagList)innerCompound, registry);
        }
    }

    public static void recursivelyApplyIDFixTags(NBTTagList list, MCRegistry registry) {
        int tagType = list.func_150303_d();
        switch (tagType) {
            case 10: {
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    IvWorldData.recursivelyApplyIDFixTags(list.func_150305_b(i), registry);
                }
                break;
            }
        }
    }

    public static void applyIDFixTags(NBTTagCompound compound, MCRegistry registry) {
        if (compound.func_74764_b(ID_FIX_TAG_KEY)) {
            NBTTagList list = compound.func_150295_c(ID_FIX_TAG_KEY, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound fixTag = list.func_150305_b(i);
                String type = fixTag.func_74779_i("type");
                if (!"item".equals(type)) continue;
                String dest = fixTag.func_74779_i("tagDest");
                String stringID = fixTag.func_74779_i("itemID");
                Item item = registry.itemFromID(stringID);
                if (item != null) {
                    int itemID = Item.func_150891_b((Item)item);
                    compound.func_74768_a(dest, itemID);
                    continue;
                }
                System.out.println("Failed to fix item tag from structure with ID '" + stringID + "'");
            }
        }
    }
}

