/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.entities;

import io.netty.buffer.ByteBuf;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.network.IvNetworkHelperServer;
import ivorius.ivtoolkit.network.PartialUpdateHandler;
import ivorius.reccomplex.RecurrentComplex;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class StructureEntityInfo
implements IExtendedEntityProperties,
PartialUpdateHandler {
    private boolean hasChanges;
    public BlockCoord selectedPoint1;
    public BlockCoord selectedPoint2;
    private NBTTagCompound cachedExportStructureBlockDataNBT;
    private NBTTagCompound worldDataClipboard;

    public static StructureEntityInfo getStructureEntityInfo(Entity entity) {
        return (StructureEntityInfo)entity.getExtendedProperties("structureEntityInfo");
    }

    public static void initInEntity(Entity entity) {
        entity.registerExtendedProperties("structureEntityInfo", (IExtendedEntityProperties)new StructureEntityInfo());
    }

    public boolean hasValidSelection() {
        return this.selectedPoint1 != null && this.selectedPoint2 != null;
    }

    public void sendSelectionChangesToClients(Entity entity) {
        IvNetworkHelperServer.sendEEPUpdatePacket(entity, "structureEntityInfo", "selection", RecurrentComplex.network);
    }

    public NBTTagCompound getCachedExportStructureBlockDataNBT() {
        return this.cachedExportStructureBlockDataNBT;
    }

    public void setCachedExportStructureBlockDataNBT(NBTTagCompound cachedExportStructureBlockDataNBT) {
        this.cachedExportStructureBlockDataNBT = cachedExportStructureBlockDataNBT;
    }

    public NBTTagCompound getWorldDataClipboard() {
        return this.worldDataClipboard;
    }

    public void setWorldDataClipboard(NBTTagCompound worldDataClipboard) {
        this.worldDataClipboard = worldDataClipboard;
    }

    public void saveNBTData(NBTTagCompound compound) {
        BlockCoord.writeCoordToNBT("selectedPoint1", this.selectedPoint1, compound);
        BlockCoord.writeCoordToNBT("selectedPoint2", this.selectedPoint2, compound);
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.selectedPoint1 = BlockCoord.readCoordFromNBT("selectedPoint1", compound);
        this.selectedPoint2 = BlockCoord.readCoordFromNBT("selectedPoint2", compound);
        this.hasChanges = true;
    }

    public void init(Entity entity, World world) {
    }

    public void update(Entity entity) {
        if (this.hasChanges) {
            this.hasChanges = false;
            this.sendSelectionChangesToClients(entity);
        }
    }

    @Override
    public void writeUpdateData(ByteBuf buffer, String context) {
        if ("selection".equals(context)) {
            BlockCoord.writeCoordToBuffer(this.selectedPoint1, buffer);
            BlockCoord.writeCoordToBuffer(this.selectedPoint2, buffer);
        }
    }

    @Override
    public void readUpdateData(ByteBuf buffer, String context) {
        if ("selection".equals(context)) {
            this.selectedPoint1 = BlockCoord.readCoordFromBuffer(buffer);
            this.selectedPoint2 = BlockCoord.readCoordFromBuffer(buffer);
        }
    }
}

