/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editmazeblock;

import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.reccomplex.blocks.TileEntityMazeGenerator;
import ivorius.reccomplex.gui.editmazeblock.TableDataSourceMazeComponentList;
import ivorius.reccomplex.gui.editmazeblock.TableDataSourceMazeExitList;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementButton;
import ivorius.reccomplex.gui.table.TableElementInteger;
import ivorius.reccomplex.gui.table.TableElementPropertyDefault;
import ivorius.reccomplex.gui.table.TableElementPropertyListener;
import ivorius.reccomplex.gui.table.TableNavigator;

public class TableDataSourceMazeBlock
extends TableDataSourceSegmented
implements TableElementPropertyListener,
TableElementButton.Listener {
    private TileEntityMazeGenerator mazeGenerator;
    private TableDelegate tableDelegate;
    private TableNavigator tableNavigator;

    public TableDataSourceMazeBlock(TileEntityMazeGenerator mazeGenerator, TableDelegate tableDelegate, TableNavigator tableNavigator) {
        this.mazeGenerator = mazeGenerator;
        this.tableDelegate = tableDelegate;
        this.tableNavigator = tableNavigator;
    }

    public TileEntityMazeGenerator getMazeGenerator() {
        return this.mazeGenerator;
    }

    public void setMazeGenerator(TileEntityMazeGenerator mazeGenerator) {
        this.mazeGenerator = mazeGenerator;
    }

    public TableDelegate getTableDelegate() {
        return this.tableDelegate;
    }

    public void setTableDelegate(TableDelegate tableDelegate) {
        this.tableDelegate = tableDelegate;
    }

    public TableNavigator getTableNavigator() {
        return this.tableNavigator;
    }

    public void setTableNavigator(TableNavigator tableNavigator) {
        this.tableNavigator = tableNavigator;
    }

    @Override
    public int numberOfSegments() {
        return 5;
    }

    @Override
    public int sizeOfSegment(int segment) {
        if (segment == 0 || segment == 1) {
            return 1;
        }
        return 3;
    }

    @Override
    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        if (segment == 0) {
            TableElementButton element = new TableElementButton("components", "Components", new TableElementButton.Action("edit", "Edit"));
            element.addListener(this);
            return element;
        }
        if (segment == 1) {
            TableElementButton element = new TableElementButton("exits", "Exits", new TableElementButton.Action("edit", "Edit"));
            element.addListener(this);
            return element;
        }
        if (segment == 2) {
            if (index == 0) {
                TableElementInteger element = new TableElementInteger("xShift", "Shift: X", this.mazeGenerator.getStructureShift().x, -50, 50);
                element.addPropertyListener(this);
                return element;
            }
            if (index == 1) {
                TableElementInteger element = new TableElementInteger("yShift", "Shift: Y", this.mazeGenerator.getStructureShift().y, -50, 50);
                element.addPropertyListener(this);
                return element;
            }
            if (index == 2) {
                TableElementInteger element = new TableElementInteger("zShift", "Shift: Z", this.mazeGenerator.getStructureShift().z, -50, 50);
                element.addPropertyListener(this);
                return element;
            }
        } else if (segment == 3) {
            if (index == 0) {
                TableElementInteger element = new TableElementInteger("roomSizeX", "Room Size: X", this.mazeGenerator.getRoomSize()[0], 1, 20);
                element.addPropertyListener(this);
                return element;
            }
            if (index == 1) {
                TableElementInteger element = new TableElementInteger("roomSizeY", "Room Size: Y", this.mazeGenerator.getRoomSize()[1], 1, 20);
                element.addPropertyListener(this);
                return element;
            }
            if (index == 2) {
                TableElementInteger element = new TableElementInteger("roomSizeZ", "Room Size: Z", this.mazeGenerator.getRoomSize()[2], 1, 20);
                element.addPropertyListener(this);
                return element;
            }
        } else if (segment == 4) {
            if (index == 0) {
                TableElementInteger element = new TableElementInteger("roomsX", "Rooms: X", this.mazeGenerator.getRoomNumbers()[0], 1, 20);
                element.addPropertyListener(this);
                return element;
            }
            if (index == 1) {
                TableElementInteger element = new TableElementInteger("roomsY", "Rooms: Y", this.mazeGenerator.getRoomNumbers()[1], 1, 20);
                element.addPropertyListener(this);
                return element;
            }
            if (index == 2) {
                TableElementInteger element = new TableElementInteger("roomsZ", "Rooms: Z", this.mazeGenerator.getRoomNumbers()[2], 1, 20);
                element.addPropertyListener(this);
                return element;
            }
        }
        return null;
    }

    @Override
    public void valueChanged(TableElementPropertyDefault element) {
        if ("xShift".equals(element.getID())) {
            BlockCoord shift = this.mazeGenerator.getStructureShift();
            this.mazeGenerator.setStructureShift(new BlockCoord((Integer)element.getPropertyValue(), shift.y, shift.z));
        } else if ("yShift".equals(element.getID())) {
            BlockCoord shift = this.mazeGenerator.getStructureShift();
            this.mazeGenerator.setStructureShift(new BlockCoord(shift.x, (Integer)element.getPropertyValue(), shift.z));
        } else if ("zShift".equals(element.getID())) {
            BlockCoord shift = this.mazeGenerator.getStructureShift();
            this.mazeGenerator.setStructureShift(new BlockCoord(shift.x, shift.y, (Integer)element.getPropertyValue()));
        } else if ("roomSizeX".equals(element.getID())) {
            int[] size = this.mazeGenerator.getRoomSize();
            size[0] = (Integer)element.getPropertyValue();
            this.mazeGenerator.setRoomSize(size);
        } else if ("roomSizeY".equals(element.getID())) {
            int[] size = this.mazeGenerator.getRoomSize();
            size[1] = (Integer)element.getPropertyValue();
            this.mazeGenerator.setRoomSize(size);
        } else if ("roomSizeZ".equals(element.getID())) {
            int[] size = this.mazeGenerator.getRoomSize();
            size[2] = (Integer)element.getPropertyValue();
            this.mazeGenerator.setRoomSize(size);
        } else if ("roomsX".equals(element.getID())) {
            int[] size = this.mazeGenerator.getRoomNumbers();
            size[0] = (Integer)element.getPropertyValue();
            this.mazeGenerator.setRoomNumbers(size);
        } else if ("roomsY".equals(element.getID())) {
            int[] size = this.mazeGenerator.getRoomNumbers();
            size[1] = (Integer)element.getPropertyValue();
            this.mazeGenerator.setRoomNumbers(size);
        } else if ("roomsZ".equals(element.getID())) {
            int[] size = this.mazeGenerator.getRoomNumbers();
            size[2] = (Integer)element.getPropertyValue();
            this.mazeGenerator.setRoomNumbers(size);
        }
    }

    @Override
    public void actionPerformed(TableElementButton tableElementButton, String actionID) {
        if ("components".equals(tableElementButton.getID())) {
            this.tableNavigator.pushTable(new GuiTable(this.tableDelegate, new TableDataSourceMazeComponentList(this.mazeGenerator.mazeComponents, this.tableDelegate, this.tableNavigator)));
        } else if ("exits".equals(tableElementButton.getID())) {
            this.tableNavigator.pushTable(new GuiTable(this.tableDelegate, new TableDataSourceMazeExitList(this.mazeGenerator.mazeExits, this.tableDelegate, this.tableNavigator)));
        }
    }
}

