/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure;

import ivorius.reccomplex.gui.editstructure.TableDataSourceBiomeGen;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementButton;
import ivorius.reccomplex.gui.table.TableElementPresetAction;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.worldgen.genericStructures.BiomeGenerationInfo;
import java.util.Collections;
import java.util.List;

public class TableDataSourceBiomeGenList
implements TableDataSource,
TableElementButton.Listener,
TableElementPresetAction.Listener {
    private List<BiomeGenerationInfo> biomeGenerationInfoList;
    private TableDelegate tableDelegate;
    private TableNavigator navigator;

    public TableDataSourceBiomeGenList(List<BiomeGenerationInfo> biomeGenerationInfoList, TableDelegate tableDelegate, TableNavigator navigator) {
        this.biomeGenerationInfoList = biomeGenerationInfoList;
        this.tableDelegate = tableDelegate;
        this.navigator = navigator;
    }

    public List<BiomeGenerationInfo> getBiomeGenerationInfoList() {
        return Collections.unmodifiableList(this.biomeGenerationInfoList);
    }

    public void setBiomeGenerationInfoList(List<BiomeGenerationInfo> biomeGenerationInfoList) {
        this.biomeGenerationInfoList = biomeGenerationInfoList;
    }

    public TableDelegate getTableDelegate() {
        return this.tableDelegate;
    }

    public void setTableDelegate(TableDelegate tableDelegate) {
        this.tableDelegate = tableDelegate;
    }

    public TableNavigator getNavigator() {
        return this.navigator;
    }

    public void setNavigator(TableNavigator navigator) {
        this.navigator = navigator;
    }

    @Override
    public boolean has(GuiTable table, int index) {
        return index >= 0 && index < this.biomeGenerationInfoList.size() + 2;
    }

    @Override
    public TableElement elementForIndex(GuiTable table, int index) {
        if (index == 0) {
            TableElementPresetAction elementPresetAction = new TableElementPresetAction("biomePreset", "Presets", "Apply", new TableElementButton.Action("overworld", "Overworld"), new TableElementButton.Action("underground", "Underground"), new TableElementButton.Action("ocean", "Ocean"), new TableElementButton.Action("clear", "Clear"));
            elementPresetAction.addListener(this);
            return elementPresetAction;
        }
        if (index == this.biomeGenerationInfoList.size() + 1) {
            TableElementButton addButton = new TableElementButton("addGen", "Add", new TableElementButton.Action("addGen", "Add Biome"));
            addButton.addListener(this);
            return addButton;
        }
        int biomeGenIndex = index - 1;
        TableElementButton.Action[] actions = new TableElementButton.Action[]{new TableElementButton.Action("earlier", "Earlier", biomeGenIndex > 0), new TableElementButton.Action("later", "Later", biomeGenIndex < this.biomeGenerationInfoList.size() - 1), new TableElementButton.Action("edit", "Edit"), new TableElementButton.Action("delete", "Delete")};
        BiomeGenerationInfo biomeGenerationInfo = this.biomeGenerationInfoList.get(biomeGenIndex);
        TableElementButton button = new TableElementButton("biomeGen" + biomeGenIndex, biomeGenerationInfo.getBiomeID() + " (" + biomeGenerationInfo.getActiveGenerationWeight() + ")", actions);
        button.addListener(this);
        return button;
    }

    @Override
    public void actionPerformed(TableElementButton tableElementButton, String actionID) {
        if (actionID.equals("addGen")) {
            BiomeGenerationInfo generationInfo = new BiomeGenerationInfo("", null);
            this.biomeGenerationInfoList.add(generationInfo);
            this.navigator.pushTable(new GuiTable(this.tableDelegate, new TableDataSourceBiomeGen(generationInfo, this.tableDelegate)));
        } else if (tableElementButton.getID().startsWith("biomeGen")) {
            int index = Integer.valueOf(tableElementButton.getID().substring(8));
            BiomeGenerationInfo generationInfo = this.biomeGenerationInfoList.get(index);
            switch (actionID) {
                case "edit": {
                    this.navigator.pushTable(new GuiTable(this.tableDelegate, new TableDataSourceBiomeGen(generationInfo, this.tableDelegate)));
                    break;
                }
                case "delete": {
                    this.biomeGenerationInfoList.remove(generationInfo);
                    this.tableDelegate.reloadData();
                    break;
                }
                case "earlier": {
                    this.biomeGenerationInfoList.remove(index);
                    this.biomeGenerationInfoList.add(index - 1, generationInfo);
                    this.tableDelegate.reloadData();
                    break;
                }
                case "later": {
                    this.biomeGenerationInfoList.remove(index);
                    this.biomeGenerationInfoList.add(index + 1, generationInfo);
                    this.tableDelegate.reloadData();
                }
            }
        }
    }

    @Override
    public void actionPerformed(TableElementPresetAction tableElementButton, String actionID) {
        if (tableElementButton.getID().equals("biomePreset")) {
            switch (actionID) {
                case "overworld": {
                    this.biomeGenerationInfoList.clear();
                    this.biomeGenerationInfoList.addAll(BiomeGenerationInfo.overworldBiomeGenerationList());
                    break;
                }
                case "underground": {
                    this.biomeGenerationInfoList.clear();
                    this.biomeGenerationInfoList.addAll(BiomeGenerationInfo.undergroundBiomeGenerationList());
                    break;
                }
                case "ocean": {
                    this.biomeGenerationInfoList.clear();
                    this.biomeGenerationInfoList.addAll(BiomeGenerationInfo.oceanBiomeGenerationList());
                    break;
                }
                case "clear": {
                    this.biomeGenerationInfoList.clear();
                }
            }
            this.tableDelegate.reloadData();
        }
    }
}

