/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table;

import ivorius.reccomplex.gui.table.Bounds;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableElementDefault;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;

public class TableElementButton
extends TableElementDefault {
    private GuiButton[] buttons = new GuiButton[0];
    private Action[] actions;
    private List<Listener> listeners = new ArrayList<Listener>();

    public TableElementButton(String id, String title, Action ... actions) {
        super(id, title);
        this.actions = actions;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public List<Listener> listeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public Action[] getActions() {
        return this.actions;
    }

    @Override
    public void initGui(GuiTable screen) {
        super.initGui(screen);
        Bounds bounds = this.bounds();
        this.buttons = new GuiButton[this.actions.length];
        int buttonWidth = bounds.getWidth() / this.actions.length;
        for (int i = 0; i < this.actions.length; ++i) {
            Action action = this.actions[i];
            int realWidth = buttonWidth - (i == this.actions.length - 1 ? 0 : 2);
            this.buttons[i] = new GuiButton(-1, bounds.getMinX() + buttonWidth * i, bounds.getMinY() + (bounds.getHeight() - 20) / 2, realWidth, 20, action.title);
            this.buttons[i].field_146125_m = !this.isHidden();
            this.buttons[i].field_146124_l = action.enabled;
            screen.addButton(this, i, this.buttons[i]);
        }
    }

    @Override
    public void setHidden(boolean hidden) {
        super.setHidden(hidden);
        for (GuiButton button : this.buttons) {
            button.field_146125_m = !hidden;
        }
    }

    @Override
    public void buttonClicked(int buttonID) {
        super.buttonClicked(buttonID);
        for (Listener listener : this.listeners) {
            listener.actionPerformed(this, this.actions[buttonID].id);
        }
    }

    public static class Action {
        public String id;
        public String title;
        public boolean enabled;

        public Action(String id, String title, boolean enabled) {
            this.id = id;
            this.title = title;
            this.enabled = enabled;
        }

        public Action(String id, String title) {
            this(id, title, true);
        }
    }

    public static interface Listener {
        public void actionPerformed(TableElementButton var1, String var2);
    }
}

