/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.worldgen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.json.NbtToJson;
import ivorius.reccomplex.json.StringTypeAdapterFactory;
import ivorius.reccomplex.worldgen.StructureInfo;
import ivorius.reccomplex.worldgen.StructureSaveHandler;
import ivorius.reccomplex.worldgen.StructureSelector;
import ivorius.reccomplex.worldgen.blockTransformers.BlockTransformer;
import ivorius.reccomplex.worldgen.blockTransformers.BlockTransformerProvider;
import ivorius.reccomplex.worldgen.genericStructures.BiomeGenerationInfo;
import ivorius.reccomplex.worldgen.genericStructures.GenericStructureInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenBase;

public class StructureHandler {
    private static Map<String, StructureInfo> allStructures = new HashMap<String, StructureInfo>();
    private static Map<String, StructureInfo> generatingStructures = new HashMap<String, StructureInfo>();
    private static Map<String, StructureSelector> structureSelectorsInBiomes = new HashMap<String, StructureSelector>();
    private static StringTypeAdapterFactory<BlockTransformer> blockTransformerAdapterFactory;
    private static Map<String, BlockTransformerProvider> blockTransformerProviders;
    private static Gson gson;

    public static Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(GenericStructureInfo.class, (Object)new GenericStructureInfo.Serializer());
        builder.registerTypeAdapter(BiomeGenerationInfo.class, (Object)new BiomeGenerationInfo.Serializer());
        blockTransformerAdapterFactory = new StringTypeAdapterFactory("transformer", "type");
        builder.registerTypeHierarchyAdapter(BlockTransformer.class, blockTransformerAdapterFactory);
        NbtToJson.registerSafeNBTSerializer(builder);
        return builder.create();
    }

    public static void registerStructure(StructureInfo info, String name, boolean generates) {
        if (info.areDependenciesResolved()) {
            RecurrentComplex.logger.info(allStructures.containsKey(name) ? "Overwrote structure with structureTitle '" + name + "'" : "Registered structure with structureTitle '" + name + "'");
            allStructures.put(name, info);
            if (generates) {
                generatingStructures.put(name, info);
                structureSelectorsInBiomes.clear();
            }
        }
    }

    public static void registerStructure(ResourceLocation resourceLocation, String name, boolean generates) {
        GenericStructureInfo structureInfo = StructureSaveHandler.structureInfoFromResource(resourceLocation);
        if (structureInfo != null) {
            StructureHandler.registerStructure(structureInfo, name, generates);
        }
    }

    public static void registerStructures(String modID, boolean generating, String ... names) {
        String path = generating ? "structures/genericStructures/" : "structures/silentStructures/";
        for (String name : names) {
            StructureHandler.registerStructure(new ResourceLocation(modID, path + name + ".zip"), name, generating);
        }
    }

    public static StructureInfo getStructure(String name) {
        return allStructures.get(name);
    }

    public static void removeStructure(String name) {
        allStructures.remove(name);
        generatingStructures.remove(name);
        structureSelectorsInBiomes.clear();
    }

    public static GenericStructureInfo createStructureFromJSON(String jsonData) {
        return (GenericStructureInfo)gson.fromJson(jsonData, GenericStructureInfo.class);
    }

    public static String createJSONFromStructure(GenericStructureInfo structureInfo) {
        return gson.toJson((Object)structureInfo, GenericStructureInfo.class);
    }

    public static Collection<StructureInfo> getAllStructures() {
        return allStructures.values();
    }

    public static Collection<StructureInfo> getAllGeneratingStructures() {
        return generatingStructures.values();
    }

    public static Set<String> getAllStructureNames() {
        return allStructures.keySet();
    }

    public static StructureSelector getStructureSelectorInBiome(BiomeGenBase biome) {
        if (!structureSelectorsInBiomes.containsKey(biome.field_76791_y)) {
            structureSelectorsInBiomes.put(biome.field_76791_y, new StructureSelector(StructureHandler.getAllGeneratingStructures(), biome));
        }
        return structureSelectorsInBiomes.get(biome.field_76791_y);
    }

    public static StringTypeAdapterFactory<BlockTransformer> blockTransformerAdapterFactory() {
        return blockTransformerAdapterFactory;
    }

    public static <T extends BlockTransformer> void registerBlockTransformer(String id, Class<T> clazz, BlockTransformerProvider<T> provider) {
        blockTransformerAdapterFactory.register(id, clazz, provider.serializer(), provider.deserializer());
        blockTransformerProviders.put(id, provider);
    }

    public static Class<? extends BlockTransformer> blockTransformerTypeForID(String id) {
        return blockTransformerAdapterFactory.objectClass(id);
    }

    public static String blockTransformerIDForType(Class<? extends BlockTransformer> type) {
        return blockTransformerAdapterFactory.type(type);
    }

    public static Collection<String> allBlockTransformerIDs() {
        return blockTransformerAdapterFactory.allIDs();
    }

    public static BlockTransformerProvider blockTransformerProviderForID(String id) {
        return blockTransformerProviders.get(id);
    }

    static {
        blockTransformerProviders = new HashMap<String, BlockTransformerProvider>();
        gson = StructureHandler.createGson();
    }
}

