/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.gui;

import ivorius.ivtoolkit.gui.GuiControlListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import org.lwjgl.opengl.GL11;

public class GuiSlider
extends GuiButton {
    private float value;
    public boolean mousePressedInside;
    private List<GuiControlListener<GuiSlider>> listeners = new ArrayList<GuiControlListener<GuiSlider>>();
    private float minValue = 0.0f;
    private float maxValue = 1.0f;

    public GuiSlider(int id, int x, int y, int width, int height, String displayString) {
        super(id, x, y, width, height, displayString);
    }

    public int func_146114_a(boolean mouseHovering) {
        return 0;
    }

    protected void func_146119_b(Minecraft mc, int x, int y) {
        if (this.field_146125_m) {
            if (this.mousePressedInside) {
                this.value = (float)(x - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                this.value = this.value * (this.maxValue - this.minValue) + this.minValue;
                if (this.value < this.minValue) {
                    this.value = this.minValue;
                }
                if (this.value > this.maxValue) {
                    this.value = this.maxValue;
                }
                this.notifyOfChanges();
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float drawVal = (this.value - this.minValue) / (this.maxValue - this.minValue);
            this.func_73729_b(this.field_146128_h + (int)(drawVal * (float)(this.field_146120_f - 8)), this.field_146129_i, 0, 66, 4, this.field_146121_g);
            this.func_73729_b(this.field_146128_h + (int)(drawVal * (float)(this.field_146120_f - 8)) + 4, this.field_146129_i, 196, 66, 4, this.field_146121_g);
        }
    }

    public boolean func_146116_c(Minecraft mc, int x, int y) {
        if (super.func_146116_c(mc, x, y)) {
            this.value = (float)(x - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
            this.value = this.value * (this.maxValue - this.minValue) + this.minValue;
            if (this.value < this.minValue) {
                this.value = this.minValue;
            }
            if (this.value > this.maxValue) {
                this.value = this.maxValue;
            }
            this.mousePressedInside = true;
            this.notifyOfChanges();
            return true;
        }
        return false;
    }

    public void func_146118_a(int x, int y) {
        this.mousePressedInside = false;
    }

    private void notifyOfChanges() {
        for (GuiControlListener<GuiSlider> listener : this.listeners) {
            listener.valueChanged(this);
        }
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public void setMinValue(float minValue) {
        this.minValue = minValue;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(float maxValue) {
        this.maxValue = maxValue;
    }

    public void addListener(GuiControlListener<GuiSlider> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(GuiControlListener<GuiSlider> listener) {
        this.listeners.remove(listener);
    }

    public List<GuiControlListener<GuiSlider>> listeners() {
        return Collections.unmodifiableList(this.listeners);
    }
}

