/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands;

import ivorius.ivtoolkit.tools.IvGsonHelper;
import ivorius.reccomplex.worldgen.genericStructures.BiomeGenerationInfo;
import java.util.List;
import java.util.Set;
import joptsimple.internal.Strings;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class CommandBiomeDict
extends CommandBase {
    public String func_71517_b() {
        return "biomedict";
    }

    public String func_71518_a(ICommandSender commandSender) {
        return "commands.biomedict.usage";
    }

    public void func_71515_b(ICommandSender commandSender, String[] args) {
        if (args.length < 2) {
            throw new WrongUsageException("commands.biomedict.usage", new Object[0]);
        }
        if (args[0].equals("get")) {
            Set<BiomeGenBase> biomes = BiomeGenerationInfo.gatherAllBiomes();
            boolean didFindBiome = false;
            String[] biomeNameArgs = new String[args.length - 1];
            System.arraycopy(args, 1, biomeNameArgs, 0, biomeNameArgs.length);
            String biomeName = Strings.join((String[])biomeNameArgs, (String)" ");
            for (BiomeGenBase biomeGenBase : biomes) {
                if (!biomeGenBase.field_76791_y.equals(biomeName)) continue;
                BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((BiomeGenBase)biomeGenBase);
                String[] typeNames = new String[types.length];
                for (int i = 0; i < types.length; ++i) {
                    typeNames[i] = IvGsonHelper.serializedName((Enum)types[i]);
                }
                commandSender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.biomedict.get", new Object[]{biomeName, Strings.join((String[])typeNames, (String)", ")}));
                didFindBiome = true;
                break;
            }
            if (!didFindBiome) {
                commandSender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.biomedict.nobiome", new Object[]{biomeName}));
            }
        } else if (args[0].equals("list")) {
            BiomeDictionary.Type type = (BiomeDictionary.Type)IvGsonHelper.enumForNameIgnoreCase((String)args[1], (Enum[])BiomeDictionary.Type.values());
            if (type != null) {
                BiomeGenBase[] biomes = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type);
                String[] biomeNames = new String[biomes.length];
                for (int i = 0; i < biomes.length; ++i) {
                    biomeNames[i] = biomes[i].field_76791_y;
                }
                commandSender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.biomedict.list", new Object[]{args[1], Strings.join((String[])biomeNames, (String)", ")}));
            } else {
                commandSender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.biomedict.notype", new Object[]{args[1]}));
            }
        } else {
            throw new WrongUsageException("commands.biomedict.usage", new Object[0]);
        }
    }

    public List func_71516_a(ICommandSender commandSender, String[] args) {
        if (args.length == 1) {
            return CommandBiomeDict.func_71530_a((String[])args, (String[])new String[]{"get", "list"});
        }
        if (args[0].equals("get")) {
            Set<BiomeGenBase> biomes = BiomeGenerationInfo.gatherAllBiomes();
            String[] biomeNames = new String[biomes.size()];
            int index = 0;
            for (BiomeGenBase biome : biomes) {
                biomeNames[index++] = biome.field_76791_y;
            }
            return CommandBiomeDict.func_71530_a((String[])args, (String[])biomeNames);
        }
        if (args[0].equals("list")) {
            BiomeDictionary.Type[] types = BiomeDictionary.Type.values();
            String[] typeNames = new String[types.length];
            for (int i = 0; i < types.length; ++i) {
                typeNames[i] = IvGsonHelper.serializedName((Enum)types[i]);
            }
            return CommandBiomeDict.func_71530_a((String[])args, (String[])typeNames);
        }
        return null;
    }
}

