/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands;

import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.tools.IvWorldData;
import ivorius.reccomplex.entities.StructureEntityInfo;
import ivorius.reccomplex.network.PacketEditStructureHandler;
import ivorius.reccomplex.worldgen.StructureHandler;
import ivorius.reccomplex.worldgen.StructureInfo;
import ivorius.reccomplex.worldgen.genericStructures.GenericStructureInfo;
import java.util.List;
import java.util.Set;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;

public class CommandExportStructure
extends CommandBase {
    public String func_71517_b() {
        return "strucExport";
    }

    public String func_71518_a(ICommandSender var1) {
        return "commands.strucExport.usage";
    }

    public void func_71515_b(ICommandSender commandSender, String[] args) {
        String structureName;
        GenericStructureInfo genericStructureInfo;
        EntityPlayerMP player = CommandExportStructure.func_71521_c((ICommandSender)commandSender);
        if (player == null) {
            throw new WrongUsageException("commands.strucExport.noPlayer", new Object[0]);
        }
        StructureEntityInfo structureEntityInfo = StructureEntityInfo.getStructureEntityInfo((Entity)player);
        if (!structureEntityInfo.hasValidSelection()) {
            throw new WrongUsageException("commands.selectModify.noSelection", new Object[0]);
        }
        BlockCoord smaller = structureEntityInfo.selectedPoint1.getLowerCorner(structureEntityInfo.selectedPoint2);
        BlockCoord bigger = structureEntityInfo.selectedPoint1.getHigherCorner(structureEntityInfo.selectedPoint2);
        int x = smaller.x;
        int y = smaller.y;
        int z = smaller.z;
        int width = bigger.x - smaller.x + 1;
        int height = bigger.y - smaller.y + 1;
        int length = bigger.z - smaller.z + 1;
        if (args.length >= 1) {
            genericStructureInfo = CommandExportStructure.getGenericStructureInfo(args[0]);
            structureName = args[0];
        } else {
            genericStructureInfo = GenericStructureInfo.createDefaultStructure();
            structureName = "NewStructure";
        }
        BlockCoord lowerCoord = new BlockCoord(x, y, z);
        BlockCoord higherCoord = new BlockCoord(x + width - 1, y + height - 1, z + length - 1);
        IvWorldData data = new IvWorldData(player.func_130014_f_(), new BlockArea(lowerCoord, higherCoord), true);
        genericStructureInfo.worldDataCompound = data.createTagCompound(lowerCoord);
        PacketEditStructureHandler.sendEditStructure(genericStructureInfo, structureName, player);
    }

    public List func_71516_a(ICommandSender commandSender, String[] args) {
        if (args.length == 1) {
            Set<String> allStructureNames = StructureHandler.getAllStructureNames();
            return CommandExportStructure.func_71530_a((String[])args, (String[])allStructureNames.toArray(new String[allStructureNames.size()]));
        }
        return null;
    }

    public static GenericStructureInfo getGenericStructureInfo(String name) {
        StructureInfo structureInfo = StructureHandler.getStructure(name);
        if (structureInfo == null) {
            throw new WrongUsageException("commands.structure.notRegistered", new Object[]{name});
        }
        GenericStructureInfo genericStructureInfo = structureInfo.copyAsGenericStructureInfo();
        if (genericStructureInfo == null) {
            throw new WrongUsageException("commands.structure.notGeneric", new Object[]{name});
        }
        return genericStructureInfo;
    }
}

