/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editinventorygen;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import ivorius.ivtoolkit.gui.FloatRange;
import ivorius.ivtoolkit.gui.GuiControlListener;
import ivorius.ivtoolkit.gui.GuiSlider;
import ivorius.ivtoolkit.gui.GuiSliderRange;
import ivorius.ivtoolkit.gui.IntegerRange;
import ivorius.ivtoolkit.network.PacketGuiAction;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.gui.GuiValidityStateIndicator;
import ivorius.reccomplex.gui.InventoryWatcher;
import ivorius.reccomplex.gui.editinventorygen.ContainerEditInventoryGen;
import ivorius.reccomplex.network.PacketEditInventoryGenerator;
import ivorius.reccomplex.worldgen.inventory.GenericInventoryGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.WeightedRandomChestContent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiEditInventoryGen
extends GuiContainer
implements InventoryWatcher,
GuiControlListener {
    public static ResourceLocation textureBackground = new ResourceLocation("reccomplex", RecurrentComplex.filePathTextures + "guiEditInventoryGen.png");
    public String key;
    private GenericInventoryGenerator inventoryGenerator;
    private GuiTextField nameTextField;
    private GuiButton saveBtn;
    private GuiButton cancelBtn;
    private GuiButton nextPageBtn;
    private GuiButton prevPageBtn;
    private GuiSliderRange itemNumberRangeSlider;
    private GuiTextField dependencyTextField;
    private GuiValidityStateIndicator dependencyStateIndicator;
    private List<GuiSlider> weightSliders = new ArrayList<GuiSlider>();
    private List<GuiSliderRange> minMaxSliders = new ArrayList<GuiSliderRange>();
    private int currentColShift;

    public GuiEditInventoryGen(EntityPlayer player, GenericInventoryGenerator generator, String key) {
        super((Container)new ContainerEditInventoryGen(player, generator));
        this.inventoryGenerator = generator;
        this.key = key;
        this.field_146999_f = 308;
        this.field_147000_g = 219;
        ((ContainerEditInventoryGen)this.field_147002_h).inventory.addWatcher(this);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        this.weightSliders.clear();
        this.minMaxSliders.clear();
        int shiftRight = this.field_146294_l / 2 - this.field_146999_f / 2;
        int shiftTop = this.field_146295_m / 2 - this.field_147000_g / 2;
        int shiftRightPage = shiftRight + 288;
        this.nameTextField = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 150, this.field_146295_m / 2 - 110, 142, 20);
        this.saveBtn = new GuiButton(0, this.field_146294_l / 2, this.field_146295_m / 2 - 110, 70, 20, I18n.func_135052_a((String)"guiGenericInventory.save", (Object[])new Object[0]));
        this.field_146292_n.add(this.saveBtn);
        this.cancelBtn = new GuiButton(1, this.field_146294_l / 2 + 75, this.field_146295_m / 2 - 110, 70, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]));
        this.field_146292_n.add(this.cancelBtn);
        this.itemNumberRangeSlider = new GuiSliderRange(4, this.field_146294_l / 2 - 150, this.field_146295_m / 2 - 85, 142, 20, "");
        this.field_146292_n.add(this.itemNumberRangeSlider);
        this.itemNumberRangeSlider.setMinValue(0.0f);
        this.itemNumberRangeSlider.setMaxValue(60.0f);
        this.itemNumberRangeSlider.addListener(this);
        this.dependencyTextField = new GuiTextField(this.field_146289_q, this.field_146294_l / 2, this.field_146295_m / 2 - 85, 130, 20);
        this.dependencyStateIndicator = new GuiValidityStateIndicator(this.field_146294_l / 2 + 135, this.field_146295_m / 2 - 80, this.inventoryGenerator.areDependenciesResolved() ? GuiValidityStateIndicator.State.VALID : GuiValidityStateIndicator.State.SEMI_VALID);
        this.nextPageBtn = new GuiButton(2, shiftRightPage, this.field_146295_m / 2 - 50, 20, 20, ">");
        this.field_146292_n.add(this.nextPageBtn);
        this.prevPageBtn = new GuiButton(3, shiftRightPage, this.field_146295_m / 2 - 20, 20, 20, "<");
        this.field_146292_n.add(this.prevPageBtn);
        this.nameTextField.func_146203_f(Short.MAX_VALUE);
        this.nameTextField.func_146195_b(true);
        this.nameTextField.func_146180_a(this.key);
        for (int col = 0; col < 1; ++col) {
            for (int row = 0; row < 4; ++row) {
                int availableSize = 262;
                int baseX = shiftRight + 20 + col * 288;
                int onePart = availableSize / 5;
                GuiSliderRange minMaxSlider = new GuiSliderRange(100, baseX, shiftTop + 48 + row * 18, onePart * 2 - 2, 18, "");
                minMaxSlider.addListener(this);
                minMaxSlider.setMinValue(1.0f);
                this.field_146292_n.add(minMaxSlider);
                this.minMaxSliders.add(minMaxSlider);
                GuiSlider weightSlider = new GuiSlider(200, baseX + onePart * 2, shiftTop + 48 + row * 18, onePart * 3, 18, I18n.func_135052_a((String)"guiGenericInventory.weight", (Object[])new Object[0]));
                weightSlider.addListener(this);
                weightSlider.setMinValue(1.0f);
                weightSlider.setMaxValue(500.0f);
                this.field_146292_n.add(weightSlider);
                this.weightSliders.add(weightSlider);
            }
        }
        this.saveBtn.field_146124_l = this.nameTextField.func_146179_b().trim().length() > 0;
        this.scrollTo(this.currentColShift);
        this.updateGenAmountSliders();
    }

    public void scrollTo(int colShift) {
        this.currentColShift = colShift;
        ((ContainerEditInventoryGen)this.field_147002_h).scrollTo(colShift);
        this.updateAllItemSliders();
        this.updatePageButtons();
    }

    private void updateAllItemSliders() {
        List<WeightedRandomChestContent> chestContents = this.inventoryGenerator.weightedRandomChestContents;
        for (int i = 0; i < this.weightSliders.size(); ++i) {
            GuiSlider weightSlider = this.weightSliders.get(i);
            GuiSliderRange minMaxSlider = this.minMaxSliders.get(i);
            int index = i + this.currentColShift * 4;
            weightSlider.field_146127_k = index + 100;
            minMaxSlider.field_146127_k = index + 200;
            if (index < chestContents.size()) {
                WeightedRandomChestContent chestContent = chestContents.get(index);
                minMaxSlider.setRange(new FloatRange(chestContent.field_76295_d, chestContent.field_76296_e));
                minMaxSlider.setMaxValue(chestContent.field_76297_b.func_77976_d());
                minMaxSlider.field_146124_l = true;
                minMaxSlider.field_146126_j = I18n.func_135052_a((String)"guiGenericInventory.minMax", (Object[])new Object[]{chestContent.field_76295_d, chestContent.field_76296_e});
                weightSlider.setValue(chestContent.field_76292_a);
                weightSlider.field_146124_l = true;
                weightSlider.field_146126_j = I18n.func_135052_a((String)"guiGenericInventory.weightNumber", (Object[])new Object[]{"" + MathHelper.func_76141_d((float)weightSlider.getValue())});
                continue;
            }
            minMaxSlider.setRange(new FloatRange(1.0f, 1.0f));
            minMaxSlider.setMaxValue(64.0f);
            minMaxSlider.field_146124_l = false;
            minMaxSlider.field_146126_j = "Min - Max";
            weightSlider.setValue(weightSlider.getMinValue());
            weightSlider.field_146124_l = false;
            weightSlider.field_146126_j = I18n.func_135052_a((String)"guiGenericInventory.weight", (Object[])new Object[0]);
        }
    }

    private void updateGenAmountSliders() {
        this.itemNumberRangeSlider.setRange(new FloatRange(this.inventoryGenerator.minItems, this.inventoryGenerator.maxItems));
        this.itemNumberRangeSlider.field_146126_j = I18n.func_135052_a((String)"guiGenericInventory.minMaxItems", (Object[])new Object[]{this.inventoryGenerator.minItems, this.inventoryGenerator.maxItems});
    }

    private void updatePageButtons() {
        List<WeightedRandomChestContent> chestContents = this.inventoryGenerator.weightedRandomChestContents;
        int neededCols = chestContents.size() / 4 + 1;
        this.nextPageBtn.field_146124_l = this.currentColShift + 1 < neededCols;
        this.prevPageBtn.field_146124_l = this.currentColShift > 0;
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.nameTextField.func_146178_a();
        this.dependencyTextField.func_146178_a();
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == 1) {
                this.field_146297_k.field_71439_g.func_71053_j();
            } else if (button.field_146127_k == 0) {
                RecurrentComplex.network.sendToServer((IMessage)new PacketEditInventoryGenerator(this.key, this.inventoryGenerator));
                this.field_146297_k.field_71439_g.func_71053_j();
            } else if (button.field_146127_k == 2) {
                this.scrollTo(this.currentColShift + 1);
                RecurrentComplex.network.sendToServer((IMessage)PacketGuiAction.packetGuiAction("igSelectCol", this.currentColShift));
            } else if (button.field_146127_k == 3) {
                this.scrollTo(this.currentColShift - 1);
                RecurrentComplex.network.sendToServer((IMessage)PacketGuiAction.packetGuiAction("igSelectCol", this.currentColShift));
            }
        }
    }

    protected void func_73869_a(char par1, int par2) {
        if (par2 != 1 && par2 != this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            super.func_73869_a(par1, par2);
        }
        if (this.nameTextField.func_146201_a(par1, par2)) {
            this.key = this.nameTextField.func_146179_b();
        } else if (this.dependencyTextField.func_146201_a(par1, par2)) {
            this.inventoryGenerator.dependencies.clear();
            String[] dependencies = this.dependencyTextField.func_146179_b().split(",");
            if (dependencies.length != 1 || dependencies[0].trim().length() > 0) {
                Collections.addAll(this.inventoryGenerator.dependencies, dependencies);
            }
            this.dependencyStateIndicator.setState(this.inventoryGenerator.areDependenciesResolved() ? GuiValidityStateIndicator.State.VALID : GuiValidityStateIndicator.State.SEMI_VALID);
        } else if (par2 == 203 && this.prevPageBtn.field_146124_l) {
            this.func_146284_a(this.prevPageBtn);
        } else if (par2 == 205 && this.nextPageBtn.field_146124_l) {
            this.func_146284_a(this.nextPageBtn);
        }
        this.saveBtn.field_146124_l = this.key.trim().length() > 0;
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        super.func_73864_a(par1, par2, par3);
        this.nameTextField.func_146192_a(par1, par2, par3);
        this.dependencyTextField.func_146192_a(par1, par2, par3);
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        this.nameTextField.func_146194_f();
        this.dependencyTextField.func_146194_f();
        if (StringUtils.func_151246_b((String)this.dependencyTextField.func_146179_b())) {
            this.func_73731_b(this.field_146289_q, "Dependencies (A,B,C...)", this.field_146294_l / 2 + 5, this.field_146295_m / 2 - 85 + 7, -7829368);
        }
        this.dependencyStateIndicator.draw();
        this.field_146297_k.func_110434_K().func_110577_a(textureBackground);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.field_146294_l / 2 - 88 - 10 - 1, MathHelper.func_76123_f((float)((float)this.field_146295_m * 0.5f)) + 17, 0, 0, 176, 90);
        for (int i = 0; i < 4; ++i) {
            this.func_73729_b(this.field_146294_l / 2 - 144 - 11, this.field_146295_m / 2 - 61 + i * 18, 7, 7, 18, 18);
        }
    }

    @Override
    public void inventoryChanged(IInventory inventory) {
        this.updateAllItemSliders();
        this.updatePageButtons();
    }

    public void valueChanged(Gui gui) {
        List<WeightedRandomChestContent> chestContents = this.inventoryGenerator.weightedRandomChestContents;
        if (gui instanceof GuiSlider) {
            int stackIndex;
            GuiSlider slider = (GuiSlider)gui;
            int value = MathHelper.func_76141_d((float)slider.getValue());
            slider.setValue(value);
            if (slider.field_146127_k < 200 && slider.field_146127_k >= 100 && (stackIndex = slider.field_146127_k - 100) < chestContents.size()) {
                chestContents.get((int)stackIndex).field_76292_a = value;
                this.updateAllItemSliders();
            }
        } else if (gui instanceof GuiSliderRange) {
            int stackIndex;
            GuiSliderRange slider = (GuiSliderRange)gui;
            if (slider.field_146127_k == 4) {
                IntegerRange intRange = new IntegerRange(slider.getRange());
                this.inventoryGenerator.minItems = intRange.getMin();
                this.inventoryGenerator.maxItems = intRange.getMax();
                this.updateGenAmountSliders();
            } else if (slider.field_146127_k < 300 && (stackIndex = slider.field_146127_k - 200) < chestContents.size()) {
                WeightedRandomChestContent chestContent = chestContents.get(stackIndex);
                IntegerRange intRange = new IntegerRange(slider.getRange());
                chestContent.field_76295_d = intRange.getMin();
                chestContent.field_76296_e = intRange.getMax();
                slider.setRange(new FloatRange(chestContent.field_76295_d, chestContent.field_76296_e));
                this.updateAllItemSliders();
            }
        }
    }

    protected void func_146286_b(int p_146286_1_, int p_146286_2_, int p_146286_3_) {
        super.func_146286_b(p_146286_1_, p_146286_2_, p_146286_3_);
        if (p_146286_3_ == 0) {
            for (Object object : this.field_146292_n) {
                GuiButton button = (GuiButton)object;
                button.func_146118_a(p_146286_1_, p_146286_2_);
            }
        }
    }
}

