/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editmazeblock;

import ivorius.ivtoolkit.maze.MazePath;
import ivorius.reccomplex.gui.editmazeblock.TableDataSourceMazePath;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementButton;
import ivorius.reccomplex.gui.table.TableNavigator;
import java.util.List;

public class TableDataSourceMazeExitList
implements TableDataSource,
TableElementButton.Listener {
    private List<MazePath> mazeExitList;
    private TableDelegate tableDelegate;
    private TableNavigator navigator;

    public TableDataSourceMazeExitList(List<MazePath> mazeExitList, TableDelegate tableDelegate, TableNavigator navigator) {
        this.mazeExitList = mazeExitList;
        this.tableDelegate = tableDelegate;
        this.navigator = navigator;
    }

    public List<MazePath> getMazeExitList() {
        return this.mazeExitList;
    }

    public void setMazeExitList(List<MazePath> mazeExitList) {
        this.mazeExitList = mazeExitList;
    }

    public TableDelegate getTableDelegate() {
        return this.tableDelegate;
    }

    public void setTableDelegate(TableDelegate tableDelegate) {
        this.tableDelegate = tableDelegate;
    }

    public TableNavigator getNavigator() {
        return this.navigator;
    }

    public void setNavigator(TableNavigator navigator) {
        this.navigator = navigator;
    }

    @Override
    public boolean has(GuiTable table, int index) {
        return index >= 0 && index < this.mazeExitList.size() + 1;
    }

    @Override
    public TableElement elementForIndex(GuiTable table, int index) {
        if (index == this.mazeExitList.size()) {
            TableElementButton addButton = new TableElementButton("addExit", "Add", new TableElementButton.Action("addExit", "Add Exit"));
            addButton.addListener(this);
            return addButton;
        }
        TableElementButton button = new TableElementButton("mazeExit" + index, "Exit", new TableElementButton.Action("edit", "Edit"), new TableElementButton.Action("delete", "Delete"));
        button.addListener(this);
        return button;
    }

    @Override
    public void actionPerformed(TableElementButton tableElementButton, String actionID) {
        if (actionID.equals("addExit")) {
            MazePath exit = new MazePath(2, false, 0, 0, 0);
            this.mazeExitList.add(exit);
            this.navigator.pushTable(new GuiTable(this.tableDelegate, new TableDataSourceMazePath(exit)));
        } else if (tableElementButton.getID().startsWith("mazeExit")) {
            int index = Integer.valueOf(tableElementButton.getID().substring(8));
            MazePath exit = this.mazeExitList.get(index);
            if (actionID.equals("edit")) {
                this.navigator.pushTable(new GuiTable(this.tableDelegate, new TableDataSourceMazePath(exit)));
            } else if (actionID.equals("delete")) {
                this.mazeExitList.remove(exit);
                this.tableDelegate.reloadData();
            }
        }
    }
}

