/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editmazeblock;

import ivorius.ivtoolkit.maze.MazePath;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementInteger;
import ivorius.reccomplex.gui.table.TableElementList;
import ivorius.reccomplex.gui.table.TableElementPropertyDefault;
import ivorius.reccomplex.gui.table.TableElementPropertyListener;
import java.util.ArrayList;
import net.minecraftforge.common.util.ForgeDirection;

public class TableDataSourceMazePath
implements TableDataSource,
TableElementPropertyListener {
    private MazePath mazePath;

    public TableDataSourceMazePath(MazePath mazePath) {
        this.mazePath = mazePath;
    }

    @Override
    public boolean has(GuiTable table, int index) {
        return index >= 0 && index <= 3;
    }

    @Override
    public TableElement elementForIndex(GuiTable table, int index) {
        if (index >= 0 && index < 3) {
            String id = "pos" + index;
            String title = index == 0 ? "Position: X" : (index == 1 ? "Position: Y" : "Position: Z");
            TableElementInteger element = new TableElementInteger(id, title, this.mazePath.sourceRoom.coordinates[index], 0, 20);
            element.addPropertyListener(this);
            return element;
        }
        if (index == 3) {
            ArrayList<TableElementList.Option> optionList = new ArrayList<TableElementList.Option>();
            optionList.add(new TableElementList.Option("0", "Down (-Y)"));
            optionList.add(new TableElementList.Option("1", "Up (+Y)"));
            optionList.add(new TableElementList.Option("2", "North (-Z)"));
            optionList.add(new TableElementList.Option("3", "South (+Z)"));
            optionList.add(new TableElementList.Option("4", "West (-X)"));
            optionList.add(new TableElementList.Option("5", "East (+X)"));
            TableElementList element = new TableElementList("side", "Side", TableDataSourceMazePath.directionFromPath(this.mazePath).ordinal() + "", optionList);
            element.addPropertyListener(this);
            return element;
        }
        return null;
    }

    @Override
    public void valueChanged(TableElementPropertyDefault element) {
        if ("side".equals(element.getID())) {
            int side = Integer.valueOf((String)element.getPropertyValue());
            MazePath path = TableDataSourceMazePath.pathFromDirection(ForgeDirection.values()[side], this.mazePath.sourceRoom.coordinates);
            this.mazePath.pathDimension = path.pathDimension;
            this.mazePath.pathGoesUp = path.pathGoesUp;
        } else {
            int index = Integer.valueOf(element.getID().substring(3));
            this.mazePath.sourceRoom.coordinates[index] = (Integer)element.getPropertyValue();
        }
    }

    private static ForgeDirection directionFromPath(MazePath path) {
        switch (path.pathDimension) {
            case 0: {
                return path.pathGoesUp ? ForgeDirection.EAST : ForgeDirection.WEST;
            }
            case 1: {
                return path.pathGoesUp ? ForgeDirection.UP : ForgeDirection.DOWN;
            }
            case 2: {
                return path.pathGoesUp ? ForgeDirection.SOUTH : ForgeDirection.NORTH;
            }
        }
        return null;
    }

    private static MazePath pathFromDirection(ForgeDirection side, int[] room) {
        int pathDim = side.offsetX != 0 ? 0 : (side.offsetY != 0 ? 1 : (side.offsetZ != 0 ? 2 : -1));
        int offset = side.offsetX + side.offsetY + side.offsetZ;
        return new MazePath(pathDim, offset > 0, room[0], room[1], room[2]);
    }
}

