/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructureblock;

import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.reccomplex.blocks.TileEntityStructureGenerator;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementInteger;
import ivorius.reccomplex.gui.table.TableElementList;
import ivorius.reccomplex.gui.table.TableElementPropertyDefault;
import ivorius.reccomplex.gui.table.TableElementPropertyListener;
import ivorius.reccomplex.gui.table.TableElementString;
import java.util.Arrays;
import joptsimple.internal.Strings;

public class TableDataSourceStructureBlock
implements TableDataSource,
TableElementPropertyListener {
    private TileEntityStructureGenerator structureGenerator;

    public TableDataSourceStructureBlock(TileEntityStructureGenerator structureGenerator) {
        this.structureGenerator = structureGenerator;
    }

    public TileEntityStructureGenerator getStructureGenerator() {
        return this.structureGenerator;
    }

    public void setStructureGenerator(TileEntityStructureGenerator structureGenerator) {
        this.structureGenerator = structureGenerator;
    }

    @Override
    public boolean has(GuiTable table, int index) {
        return index >= 0 && index < 6;
    }

    @Override
    public TableElement elementForIndex(GuiTable table, int index) {
        if (index == 0) {
            TableElementString element = new TableElementString("generators", "Generators (A,B,...)", Strings.join(this.structureGenerator.getStructureNames(), (String)","));
            element.addPropertyListener(this);
            return element;
        }
        if (index == 1) {
            TableElementInteger element = new TableElementInteger("xShift", "Shift: X", this.structureGenerator.getStructureShift().x, -50, 50);
            element.addPropertyListener(this);
            return element;
        }
        if (index == 2) {
            TableElementInteger element = new TableElementInteger("yShift", "Shift: Y", this.structureGenerator.getStructureShift().y, -50, 50);
            element.addPropertyListener(this);
            return element;
        }
        if (index == 3) {
            TableElementInteger element = new TableElementInteger("zShift", "Shift: Z", this.structureGenerator.getStructureShift().z, -50, 50);
            element.addPropertyListener(this);
            return element;
        }
        if (index == 4) {
            TableElementList element = new TableElementList("rotation", "Rotation", "" + this.structureGenerator.getStructureRotation(), new TableElementList.Option("0", "0 Clockwise"), new TableElementList.Option("1", "1 Clockwise"), new TableElementList.Option("2", "2 Clockwise"), new TableElementList.Option("3", "3 Clockwise"), new TableElementList.Option("null", "Random (if rotatable)"));
            element.addPropertyListener(this);
            return element;
        }
        if (index == 5) {
            TableElementList element = new TableElementList("mirror", "Mirror", "" + this.structureGenerator.getStructureMirror(), new TableElementList.Option("false", "false"), new TableElementList.Option("true", "true"), new TableElementList.Option("null", "Random (if mirrorable)"));
            element.addPropertyListener(this);
            return element;
        }
        return null;
    }

    @Override
    public void valueChanged(TableElementPropertyDefault element) {
        if ("generators".equals(element.getID())) {
            String value = (String)element.getPropertyValue();
            this.structureGenerator.setStructureNames(Arrays.asList(value.split(",")));
        } else if ("xShift".equals(element.getID())) {
            BlockCoord shift = this.structureGenerator.getStructureShift();
            this.structureGenerator.setStructureShift(new BlockCoord((Integer)element.getPropertyValue(), shift.y, shift.z));
        } else if ("yShift".equals(element.getID())) {
            BlockCoord shift = this.structureGenerator.getStructureShift();
            this.structureGenerator.setStructureShift(new BlockCoord(shift.x, (Integer)element.getPropertyValue(), shift.z));
        } else if ("zShift".equals(element.getID())) {
            BlockCoord shift = this.structureGenerator.getStructureShift();
            this.structureGenerator.setStructureShift(new BlockCoord(shift.x, shift.y, (Integer)element.getPropertyValue()));
        } else if ("rotation".equals(element.getID())) {
            String propertyID = (String)element.getPropertyValue();
            Integer rotation = propertyID.equals("null") ? null : Integer.valueOf(propertyID);
            this.structureGenerator.setStructureRotation(rotation);
        } else if ("mirror".equals(element.getID())) {
            String propertyID = (String)element.getPropertyValue();
            Boolean mirror = propertyID.equals("null") ? null : Boolean.valueOf(propertyID);
            this.structureGenerator.setStructureMirror(mirror);
        }
    }
}

