/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table;

import ivorius.reccomplex.gui.table.Bounds;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableElementPropertyDefault;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiButton;

public class TableElementList
extends TableElementPropertyDefault<String> {
    private GuiButton button;
    private List<Option> options;

    public TableElementList(String id, String title, String value, List<Option> options) {
        super(id, title, value);
        this.options = options;
    }

    public TableElementList(String id, String title, String value, Option ... options) {
        this(id, title, value, Arrays.asList(options));
    }

    @Override
    public void initGui(GuiTable screen) {
        super.initGui(screen);
        Bounds bounds = this.bounds();
        this.button = new GuiButton(-1, bounds.getMinX(), bounds.getMinY() + (bounds.getHeight() - 20) / 2, bounds.getWidth(), 20, "");
        this.button.field_146125_m = !this.isHidden();
        this.updateButtonTitle();
        screen.addButton(this, 0, this.button);
    }

    @Override
    public void setHidden(boolean hidden) {
        super.setHidden(hidden);
        if (this.button != null) {
            this.button.field_146125_m = !hidden;
        }
    }

    @Override
    public void setPropertyValue(String value) {
        super.setPropertyValue(value);
        this.updateButtonTitle();
    }

    @Override
    public void buttonClicked(int buttonID) {
        super.buttonClicked(buttonID);
        int prevOptionIndex = this.currentOptionIndex();
        int optionIndex = prevOptionIndex < 0 ? 0 : (prevOptionIndex + 1) % this.options.size();
        this.setPropertyValue(this.options.get((int)optionIndex).id);
        this.alertListenersOfChange();
    }

    private void updateButtonTitle() {
        if (this.button != null) {
            int index = this.currentOptionIndex();
            this.button.field_146126_j = index >= 0 ? this.options.get((int)index).title : (String)this.getPropertyValue();
        }
    }

    private int currentOptionIndex() {
        for (int i = 0; i < this.options.size(); ++i) {
            if (!this.options.get((int)i).id.equals(this.getPropertyValue())) continue;
            return i;
        }
        return -1;
    }

    public static class Option {
        public String id;
        public String title;

        public Option(String id, String title) {
            this.id = id;
            this.title = title;
        }
    }
}

