/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.items;

import ivorius.reccomplex.items.GeneratingItem;
import ivorius.reccomplex.items.ItemInventoryGenerationTag;
import ivorius.reccomplex.random.Person;
import ivorius.reccomplex.random.Poem;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Scanner;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;

public class ItemBookGenerator
extends Item
implements GeneratingItem {
    public boolean func_77648_a(ItemStack usedItem, EntityPlayer player, World world, int x, int y, int z, int par7, float par8, float par9, float par10) {
        return ItemInventoryGenerationTag.applyGeneratorToInventory(world, x, y, z, this, usedItem);
    }

    @Override
    public void generateInInventory(IInventory inventory, Random random, ItemStack stack, int fromSlot) {
        inventory.func_70299_a(fromSlot, ItemBookGenerator.getRandomBook(random));
    }

    public static ItemStack getRandomBook(Random random) {
        return random.nextFloat() < 0.5f ? ItemBookGenerator.getRandomLoreBook(random) : ItemBookGenerator.getRandomPoemBook(random);
    }

    public static ItemStack getRandomLoreBook(Random random) {
        return ItemBookGenerator.getRandomGenericBook(random);
    }

    public static ItemStack getRandomGenericBook(Random random) {
        ItemStack stack = new ItemStack(Items.field_151122_aG);
        String bookName = Person.chaoticName(random, random.nextFloat() < 0.8f);
        stack.func_151001_c(bookName);
        return stack;
    }

    public static ItemStack getRandomPoemBook(Random random) {
        ItemStack stack = new ItemStack(Items.field_151164_bB);
        Poem poem = Poem.randomPoem(random);
        Person author = Person.randomHuman(random, random.nextFloat() < 0.9f);
        stack.func_77983_a("pages", (NBTBase)ItemBookGenerator.stringList(ItemBookGenerator.bookPages(poem.getText())));
        stack.func_77983_a("author", (NBTBase)new NBTTagString(author.getFullName()));
        stack.func_77983_a("title", (NBTBase)new NBTTagString(poem.getTitle()));
        return stack;
    }

    public static NBTTagList stringList(List<String> strings) {
        NBTTagList list = new NBTTagList();
        for (String s : strings) {
            list.func_74742_a((NBTBase)new NBTTagString(s));
        }
        return list;
    }

    public static List<String> bookPages(String text) {
        String newPage;
        String[] hardcodedLines;
        ArrayList<Integer> pageIndices = new ArrayList<Integer>();
        int allowedLines = 12;
        int charsPerLine = 15;
        int currentLineChars = 0;
        int currentLineNumber = 0;
        int hardcodedLineIndex = 0;
        for (String hardcodedLine : hardcodedLines = text.split("\n")) {
            Scanner scanner = new Scanner(hardcodedLine);
            while (scanner.hasNext()) {
                String word = scanner.next();
                if (word.length() > charsPerLine) {
                    int lines = word.length() / charsPerLine;
                    if (currentLineNumber + lines > allowedLines) {
                        int index = scanner.match().end() + hardcodedLineIndex;
                        pageIndices.add(index);
                        currentLineNumber = 0;
                    }
                    currentLineNumber += lines;
                    currentLineChars = word.length() - lines * charsPerLine;
                    continue;
                }
                if (word.length() + currentLineChars > charsPerLine) {
                    if (currentLineNumber >= allowedLines) {
                        int index = scanner.match().end() + hardcodedLineIndex;
                        pageIndices.add(index);
                        currentLineNumber = 0;
                    } else {
                        ++currentLineNumber;
                    }
                    currentLineChars = word.length();
                    continue;
                }
                currentLineChars += word.length();
            }
            currentLineChars = 0;
            hardcodedLineIndex += hardcodedLine.length() + 1;
            if (++currentLineNumber < allowedLines) continue;
            pageIndices.add(hardcodedLineIndex);
            currentLineNumber = 0;
        }
        ArrayList<String> pages = new ArrayList<String>();
        int lastIndex = 0;
        for (Integer index : pageIndices) {
            String newPage2 = text.substring(lastIndex, index);
            if (newPage2.trim().length() > 0) {
                pages.add(newPage2.trim());
            }
            lastIndex = index;
        }
        if (text.length() > lastIndex && (newPage = text.substring(lastIndex, text.length())).trim().length() > 0) {
            pages.add(newPage.trim());
        }
        return pages;
    }
}

