/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.entities.StructureEntityInfo;
import ivorius.reccomplex.gui.editstructure.GuiEditGenericStructure;
import ivorius.reccomplex.network.PacketEditStructure;
import ivorius.reccomplex.worldgen.StructureSaveHandler;
import ivorius.reccomplex.worldgen.genericStructures.GenericStructureInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class PacketEditStructureHandler
implements IMessageHandler<PacketEditStructure, IMessage> {
    public static void sendEditStructure(GenericStructureInfo genericStructureInfo, String key, EntityPlayerMP player) {
        StructureEntityInfo structureEntityInfo = StructureEntityInfo.getStructureEntityInfo((Entity)player);
        if (structureEntityInfo != null) {
            structureEntityInfo.setCachedExportStructureBlockDataNBT(genericStructureInfo.worldDataCompound);
        }
        RecurrentComplex.network.sendTo((IMessage)new PacketEditStructure(key, genericStructureInfo), player);
    }

    public IMessage onMessage(PacketEditStructure message, MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            this.onMessageClient(message, ctx);
        } else {
            NetHandlerPlayServer netHandlerPlayServer = ctx.getServerHandler();
            EntityPlayerMP player = netHandlerPlayServer.field_147369_b;
            StructureEntityInfo structureEntityInfo = StructureEntityInfo.getStructureEntityInfo((Entity)player);
            GenericStructureInfo genericStructureInfo = message.getStructureInfo();
            if (structureEntityInfo != null) {
                genericStructureInfo.worldDataCompound = structureEntityInfo.getCachedExportStructureBlockDataNBT();
            }
            if (!StructureSaveHandler.saveGenericStructure(genericStructureInfo, message.getKey())) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.strucExport.failure", new Object[]{message.getKey()}));
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.strucExport.success", new Object[]{message.getKey()}));
                StructureSaveHandler.reloadAllCustomStructures();
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void onMessageClient(PacketEditStructure message, MessageContext ctx) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiEditGenericStructure(message.getKey(), message.getStructureInfo()));
    }
}

