/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.random;

import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class Person {
    private static List<String> vowels = Arrays.asList("a", "e", "i", "o", "u", "ei", "ai", "ou", "j", "ji", "y", "oi", "au", "oo");
    private static List<String> startConsonants = Arrays.asList("b", "c", "d", "f", "g", "h", "k", "l", "m", "n", "p", "q", "r", "s", "t", "v", "w", "x", "z", "ch", "bl", "br", "fl", "gl", "gr", "kl", "pr", "st", "sh", "th");
    private static List<String> endConsonants = Arrays.asList("b", "d", "f", "g", "h", "k", "l", "m", "n", "p", "r", "s", "t", "v", "w", "z", "ch", "gh", "nn", "st", "sh", "th", "tt", "ss", "pf", "nt");
    private static List<String> chaoticNameBlueprints = Arrays.asList("vdv", "cvdvd", "cvd", "vdvd");
    public static List<String> nordicNamesMale = Arrays.asList("Erik", "Magnus", "John", "William", "Lukas", "Elias", "Malik", "Aron", "Enuk", "Christian", "Peter", "Hans", "Jens", "Niels", "Kristian", "Aage", "Johannes", "Carl", "Svend", "Sven", "Jakup", "Benjamin", "Danjal", "Hanus", "Rei", "Simun", "Bardur", "Johan", "Jonas", "Aleksi", "Ville", "Niko", "Juho", "Teemu", "Joonas", "Jesse", "Joni", "Jere", "Antti", "Ole", "Lars", "Jorgen", "Jakob", "Jon", "Daniel", "Sigurdur", "Arnar", "Kristofer", "Einar", "Gunnar", "Alexander", "Andri", "Viktor", "Olof", "Lennart", "Pall");
    public static List<String> nordicNamesFemale = Arrays.asList("Emma", "Eva", "Sofia", "Pipaluk", "Emilia", "Alice", "Marie", "Anna", "Margrethe", "Kristine", "Johanne", "Karen", "Elisabeth", "Ellen", "Ingeborg", "Rebekka", "Helena", "Vir", "Ronja", "Katrin", "Liv", "Maria", "Sara", "Jenna", "Laura", "Roosa", "Veera", "Emilia", "Julia", "Sara", "Jenni", "Noora", "Ane", "Johanne", "Dorthe", "Margrethe", "Sofie", "Else", "Amalie", "Gudrun", "Helga", "Birta", "Maria");
    private String firstName;
    private String middleName;
    private String lastName;

    public Person(String firstName, String middleName, String lastName) {
        this.firstName = firstName;
        this.middleName = middleName;
        this.lastName = lastName;
    }

    public static Person randomHuman(Random random, boolean male) {
        NameType nameType = random.nextFloat() < 0.95f ? NameType.NORDIC : NameType.CHAOTIC;
        return Person.randomPerson(random, male, nameType);
    }

    public static Person randomPerson(Random random, boolean male, NameType type) {
        switch (type) {
            case CHAOTIC: {
                return Person.randomChaoticPerson(random, male);
            }
            case NORDIC: {
                return Person.randomNordicPerson(random, male);
            }
        }
        throw new RuntimeException();
    }

    private static Person randomChaoticPerson(Random random, boolean male) {
        return new Person(Person.chaoticName(random, male), random.nextFloat() < 0.15f ? Person.chaoticName(random, male) : null, random.nextFloat() < 0.4f ? Person.chaoticName(random, male) : null);
    }

    private static Person randomNordicPerson(Random random, boolean male) {
        String middleName;
        String string = middleName = random.nextFloat() < 0.3f ? Person.nordicName(random, male) : null;
        String lastName = random.nextFloat() < 0.95f ? Person.nordicLastName(random, male, random.nextFloat() < 0.1f) : null;
        return new Person(Person.nordicName(random, male), middleName, lastName);
    }

    public static String nordicName(Random random, boolean male) {
        return male ? Person.getRandomElementFrom(nordicNamesMale, random) : Person.getRandomElementFrom(nordicNamesFemale, random);
    }

    public static String nordicLastName(Random random, boolean male, boolean parentMale) {
        return Person.nordicName(random, parentMale) + (male ? "sson" : "sdottir");
    }

    public static String chaoticName(Random random, boolean male) {
        StringBuilder name = new StringBuilder();
        name.append(Person.firstCharUppercase(Person.parseChaoticName(Person.getRandomElementFrom(chaoticNameBlueprints, random), random)));
        if (random.nextFloat() < 0.2f) {
            name.append("-").append(Person.firstCharUppercase(Person.parseChaoticName(Person.getRandomElementFrom(chaoticNameBlueprints, random), random)));
        }
        return name.toString();
    }

    private static String parseChaoticName(String blueprint, Random random) {
        StringBuilder name = new StringBuilder();
        block5: for (int i = 0; i < blueprint.length(); ++i) {
            char ch = blueprint.charAt(i);
            switch (ch) {
                case 'v': {
                    name.append(Person.getRandomElementFrom(vowels, random));
                    continue block5;
                }
                case 'c': {
                    name.append(Person.getRandomElementFrom(startConsonants, random));
                    continue block5;
                }
                case 'd': {
                    name.append(Person.getRandomElementFrom(endConsonants, random));
                }
            }
        }
        return name.toString();
    }

    private static String firstCharUppercase(String name) {
        return Character.toString(name.charAt(0)).toUpperCase() + name.substring(1);
    }

    private static <O> O getRandomElementFrom(List<O> list, Random random) {
        return list.get(random.nextInt(list.size()));
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getFullName() {
        StringBuilder builder = new StringBuilder();
        if (this.firstName != null) {
            builder.append(this.firstName);
        }
        if (this.middleName != null) {
            builder.append(' ').append(this.middleName);
        }
        if (this.lastName != null) {
            builder.append(' ').append(this.lastName);
        }
        return builder.toString().trim();
    }

    public static enum NameType {
        NORDIC,
        CHAOTIC;

    }
}

